/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.benchmark;

import org.encog.engine.network.train.prop.OpenCLTrainingProfile;
import org.encog.engine.opencl.EncogCLDevice;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.propagation.resilient.ResilientPropagation;
import org.encog.util.benchmark.RandomTrainingFactory;
import org.encog.util.simple.EncogUtility;

public final class Evaluate {
    public static final int MILIS = 1000;

    public static int evaluateTrain(int n, int n2, int n3, int n4) {
        return Evaluate.evaluateTrain(null, n, n2, n3, n4);
    }

    public static int evaluateTrain(EncogCLDevice encogCLDevice, int n, int n2, int n3, int n4) {
        BasicNetwork basicNetwork = EncogUtility.simpleFeedForward(n, n2, n3, n4, true);
        BasicNeuralDataSet basicNeuralDataSet = RandomTrainingFactory.generate(1000L, 10000, n, n4, -1.0, 1.0);
        OpenCLTrainingProfile openCLTrainingProfile = null;
        if (encogCLDevice != null) {
            openCLTrainingProfile = new OpenCLTrainingProfile(encogCLDevice);
        }
        return Evaluate.evaluateTrain(openCLTrainingProfile, basicNetwork, basicNeuralDataSet);
    }

    public static int evaluateTrain(OpenCLTrainingProfile openCLTrainingProfile, BasicNetwork basicNetwork, NeuralDataSet neuralDataSet) {
        ResilientPropagation resilientPropagation = openCLTrainingProfile == null ? new ResilientPropagation(basicNetwork, neuralDataSet) : new ResilientPropagation(basicNetwork, neuralDataSet, openCLTrainingProfile, 0.1, 50.0);
        long l = System.currentTimeMillis();
        long l2 = l + 10000L;
        int n = 0;
        while (System.currentTimeMillis() < l2) {
            ++n;
            resilientPropagation.iteration();
        }
        return n;
    }
}

