/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.benchmark;

import java.io.File;
import java.io.PrintStream;
import org.encog.Encog;
import org.encog.engine.StatusReportable;
import org.encog.engine.opencl.EncogCLDevice;
import org.encog.engine.util.Format;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralDataSet;
import org.encog.neural.data.buffer.BufferedNeuralDataSet;
import org.encog.util.benchmark.Evaluate;
import org.encog.util.benchmark.RandomTrainingFactory;
import org.encog.util.logging.Logging;

public class EncogBenchmark {
    private static final int STEPS = 4;
    private static final int STEP1 = 1;
    private static final int STEP2 = 2;
    private static final int STEP3 = 3;
    private static final int STEP4 = 4;
    private final StatusReportable report;
    private int cpuScore;
    private int clScore;
    private int memoryScore;
    private int binaryScore;
    private EncogCLDevice device;

    public EncogBenchmark(StatusReportable statusReportable) {
        this.report = statusReportable;
    }

    public String process() {
        Logging.stopConsoleLogging();
        this.report.report(4, 0, "Beginning benchmark");
        this.evalCPU();
        this.evalOpenCL();
        this.evalMemory();
        this.evalBinary();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Encog Benchmark: CPU:");
        stringBuilder.append(Format.formatInteger(this.cpuScore));
        stringBuilder.append(", OpenCL");
        if (this.device == null) {
            stringBuilder.append("(none)");
        } else if (this.device.isCPU()) {
            stringBuilder.append("(cpu)");
        } else {
            stringBuilder.append("(gpu)");
        }
        stringBuilder.append(":");
        stringBuilder.append(Format.formatInteger(this.clScore));
        stringBuilder.append(", Memory:");
        stringBuilder.append(Format.formatInteger(this.memoryScore));
        stringBuilder.append(", Disk:");
        stringBuilder.append(Format.formatInteger(this.binaryScore));
        this.report.report(4, 4, stringBuilder.toString());
        return stringBuilder.toString();
    }

    private void evalCPU() {
        int n = Evaluate.evaluateTrain(2, 4, 0, 1);
        this.report.report(4, 1, "Evaluate CPU, tiny= " + Format.formatInteger(n / 100));
        int n2 = Evaluate.evaluateTrain(10, 20, 0, 1);
        this.report.report(4, 1, "Evaluate CPU, small= " + Format.formatInteger(n2 / 30));
        int n3 = Evaluate.evaluateTrain(100, 200, 40, 5);
        this.report.report(4, 1, "Evaluate CPU, large= " + Format.formatInteger(n3));
        int n4 = Evaluate.evaluateTrain(200, 300, 200, 50);
        this.report.report(4, 1, "Evaluate CPU, huge= " + Format.formatInteger(n4));
        int n5 = n / 100 + n2 / 30 + n3 + n4;
        this.report.report(4, 1, "CPU result: " + n5);
        this.cpuScore = n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalOpenCL() {
        block14: {
            try {
                if (this.device != null) break block14;
                PrintStream printStream = System.err;
                System.setErr(null);
                try {
                    if (Encog.getInstance().getCL() == null) {
                        Encog.getInstance().initCL();
                    }
                    this.device = Encog.getInstance().getCL().chooseDevice();
                }
                finally {
                    System.setErr(printStream);
                }
            }
            catch (Throwable throwable) {
                this.report.report(4, 2, "No OpenCL devices, result: 0");
                this.clScore = 0;
            }
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            n = Evaluate.evaluateTrain(this.device, 2, 4, 0, 1);
            this.report.report(4, 2, "Evaluate OpenCL, tiny= " + Format.formatInteger(n / 100));
        }
        catch (Throwable throwable) {
            this.report.report(4, 2, "Evaluate OpenCL, tiny FAILED");
        }
        try {
            n2 = Evaluate.evaluateTrain(this.device, 10, 20, 0, 1);
            this.report.report(4, 2, "Evaluate OpenCL, small= " + Format.formatInteger(n2 / 30));
        }
        catch (Throwable throwable) {
            this.report.report(4, 2, "Evaluate OpenCL, small FAILED");
        }
        try {
            n3 = Evaluate.evaluateTrain(this.device, 100, 200, 40, 5);
            this.report.report(4, 2, "Evaluate OpenCL, large= " + Format.formatInteger(n3));
        }
        catch (Throwable throwable) {
            this.report.report(4, 2, "Evaluate OpenCL, large FAILED");
        }
        try {
            n4 = Evaluate.evaluateTrain(this.device, 200, 300, 200, 50);
            this.report.report(4, 2, "Evaluate OpenCL, huge= " + Format.formatInteger(n4));
        }
        catch (Throwable throwable) {
            this.report.report(4, 2, "Evaluate OpenCL, huge FAILED");
        }
        int n5 = n / 100 + n2 / 30 + n3 + n4;
        this.report.report(4, 2, "OpenCL result: " + n5);
        this.clScore = n5;
    }

    private void evalMemory() {
        BasicNeuralDataSet basicNeuralDataSet = RandomTrainingFactory.generate(1000L, 10000, 10, 10, -1.0, 1.0);
        long l = System.currentTimeMillis();
        long l2 = l + 10000L;
        int n = 0;
        NeuralDataPair neuralDataPair = BasicNeuralDataPair.createPair(10, 10);
        int n2 = 0;
        while (System.currentTimeMillis() < l2) {
            ++n2;
            basicNeuralDataSet.getRecord(n++, neuralDataPair);
            if ((long)n < basicNeuralDataSet.getRecordCount()) continue;
            n = 0;
        }
        this.report.report(4, 3, "Memory dataset, result: " + Format.formatInteger(n2 /= 100000));
        this.memoryScore = n2;
    }

    private void evalBinary() {
        File file = new File("temp.egb");
        BasicNeuralDataSet basicNeuralDataSet = RandomTrainingFactory.generate(1000L, 10000, 10, 10, -1.0, 1.0);
        file.delete();
        BufferedNeuralDataSet bufferedNeuralDataSet = new BufferedNeuralDataSet(file);
        bufferedNeuralDataSet.load(basicNeuralDataSet);
        long l = System.currentTimeMillis();
        long l2 = l + 10000L;
        int n = 0;
        NeuralDataPair neuralDataPair = BasicNeuralDataPair.createPair(10, 10);
        int n2 = 0;
        while (System.currentTimeMillis() < l2) {
            ++n2;
            bufferedNeuralDataSet.getRecord(n++, neuralDataPair);
            if ((long)n < bufferedNeuralDataSet.getRecordCount()) continue;
            n = 0;
        }
        basicNeuralDataSet.close();
        this.report.report(4, 4, "Disk(binary) dataset, result: " + Format.formatInteger(n2 /= 100000));
        file.delete();
        this.binaryScore = n2;
    }

    public int getCpuScore() {
        return this.cpuScore;
    }

    public int getClScore() {
        return this.clScore;
    }

    public int getMemoryScore() {
        return this.memoryScore;
    }

    public int getBinaryScore() {
        return this.binaryScore;
    }

    public EncogCLDevice getDevice() {
        return this.device;
    }

    public void setDevice(EncogCLDevice encogCLDevice) {
        this.device = encogCLDevice;
    }
}

