/*
 * Decompiled with CFR 0.152.
 */
package org.encog.solve.genetic.population;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.encog.persist.EncogCollection;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.annotations.EGReferenceable;
import org.encog.persist.persistors.generic.GenericPersistor;
import org.encog.solve.genetic.genome.Genome;
import org.encog.solve.genetic.innovation.InnovationList;
import org.encog.solve.genetic.population.Population;
import org.encog.solve.genetic.species.Species;
import org.encog.util.identity.BasicGenerateID;
import org.encog.util.identity.GenerateID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EGReferenceable
public class BasicPopulation
implements Population,
EncogPersistedObject {
    private static final long serialVersionUID = -4097921208348173582L;
    private final GenerateID geneIDGenerate = new BasicGenerateID();
    private final GenerateID genomeIDGenerate = new BasicGenerateID();
    private final List<Genome> genomes = new ArrayList<Genome>();
    private final GenerateID innovationIDGenerate = new BasicGenerateID();
    private InnovationList innovations;
    private double oldAgePenalty = 0.3;
    private int oldAgeThreshold = 50;
    private int populationSize;
    private final List<Species> species = new ArrayList<Species>();
    private final GenerateID speciesIDGenerate = new BasicGenerateID();
    private double survivalRate = 0.2;
    private int youngBonusAgeThreshold = 10;
    private double youngScoreBonus = 0.3;
    private String name;
    private String description;
    private EncogCollection encogCollection;

    public BasicPopulation() {
        this.populationSize = 0;
    }

    public BasicPopulation(int n) {
        this.populationSize = n;
    }

    @Override
    public void add(Genome genome) {
        this.genomes.add(genome);
    }

    @Override
    public void addAll(List<? extends Genome> list) {
        this.genomes.addAll(list);
    }

    @Override
    public long assignGeneID() {
        return this.geneIDGenerate.generate();
    }

    @Override
    public long assignGenomeID() {
        return this.genomeIDGenerate.generate();
    }

    @Override
    public long assignInnovationID() {
        return this.innovationIDGenerate.generate();
    }

    @Override
    public long assignSpeciesID() {
        return this.speciesIDGenerate.generate();
    }

    @Override
    public void clear() {
        this.genomes.clear();
    }

    @Override
    public Persistor createPersistor() {
        return new GenericPersistor(BasicPopulation.class);
    }

    @Override
    public Genome get(int n) {
        return this.genomes.get(n);
    }

    @Override
    public Genome getBest() {
        if (this.genomes.size() == 0) {
            return null;
        }
        return this.genomes.get(0);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<Genome> getGenomes() {
        return this.genomes;
    }

    @Override
    public InnovationList getInnovations() {
        return this.innovations;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getOldAgePenalty() {
        return this.oldAgePenalty;
    }

    @Override
    public int getOldAgeThreshold() {
        return this.oldAgeThreshold;
    }

    @Override
    public int getPopulationSize() {
        return this.populationSize;
    }

    @Override
    public List<Species> getSpecies() {
        return this.species;
    }

    @Override
    public double getSurvivalRate() {
        return this.survivalRate;
    }

    @Override
    public int getYoungBonusAgeThreshold() {
        return this.youngBonusAgeThreshold;
    }

    @Override
    public double getYoungScoreBonus() {
        return this.youngScoreBonus;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public void setInnovations(InnovationList innovationList) {
        this.innovations = innovationList;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void setOldAgePenalty(double d) {
        this.oldAgePenalty = d;
    }

    @Override
    public void setOldAgeThreshold(int n) {
        this.oldAgeThreshold = n;
    }

    @Override
    public void setPopulationSize(int n) {
        this.populationSize = n;
    }

    @Override
    public void setSurvivalRate(double d) {
        this.survivalRate = d;
    }

    @Override
    public void setYoungBonusAgeThreshhold(int n) {
        this.youngBonusAgeThreshold = n;
    }

    @Override
    public void setYoungScoreBonus(double d) {
        this.youngScoreBonus = d;
    }

    @Override
    public int size() {
        return this.genomes.size();
    }

    @Override
    public void sort() {
        Collections.sort(this.genomes);
    }

    @Override
    public EncogCollection getCollection() {
        return this.encogCollection;
    }

    @Override
    public void setCollection(EncogCollection encogCollection) {
        this.encogCollection = encogCollection;
    }
}

