/*
 * Decompiled with CFR 0.152.
 */
package org.encog.solve.genetic.crossover;

import java.util.HashSet;
import java.util.Set;
import org.encog.solve.genetic.crossover.Crossover;
import org.encog.solve.genetic.genes.Gene;
import org.encog.solve.genetic.genome.Chromosome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpliceNoRepeat
implements Crossover {
    private final int cutLength;

    private static Gene getNotTaken(Chromosome chromosome, Set<Gene> set) {
        for (Gene gene : chromosome.getGenes()) {
            if (set.contains(gene)) continue;
            set.add(gene);
            return gene;
        }
        return null;
    }

    public SpliceNoRepeat(int n) {
        this.cutLength = n;
    }

    @Override
    public void mate(Chromosome chromosome, Chromosome chromosome2, Chromosome chromosome3, Chromosome chromosome4) {
        int n;
        int n2 = chromosome2.getGenes().size();
        int n3 = (int)(Math.random() * (double)(n2 - this.cutLength));
        int n4 = n3 + this.cutLength;
        HashSet<Gene> hashSet = new HashSet<Gene>();
        HashSet<Gene> hashSet2 = new HashSet<Gene>();
        for (n = 0; n < n2; ++n) {
            if (n < n3 || n > n4) continue;
            chromosome3.getGene(n).copy(chromosome2.getGene(n));
            chromosome4.getGene(n).copy(chromosome.getGene(n));
            hashSet.add(chromosome2.getGene(n));
            hashSet2.add(chromosome.getGene(n));
        }
        for (n = 0; n < n2; ++n) {
            if (n >= n3 && n <= n4) continue;
            chromosome3.getGene(n).copy(SpliceNoRepeat.getNotTaken(chromosome, hashSet));
            chromosome4.getGene(n).copy(SpliceNoRepeat.getNotTaken(chromosome2, hashSet2));
        }
    }
}

