/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import org.encog.neural.networks.synapse.WeightedSynapse;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.PersistorUtil;

public class WeightedSynapsePersistor
implements Persistor {
    public static final String TAG_WEIGHTS = "weights";

    public EncogPersistedObject load(ReadXML readXML) {
        WeightedSynapse weightedSynapse = new WeightedSynapse();
        String string = readXML.getTag().getName();
        while (readXML.readToTag()) {
            if (readXML.is(TAG_WEIGHTS, true)) {
                readXML.readToTag();
                weightedSynapse.setMatrix(PersistorUtil.loadMatrix(readXML));
            }
            if (!readXML.is(string, false)) continue;
            break;
        }
        return weightedSynapse;
    }

    public void save(EncogPersistedObject encogPersistedObject, WriteXML writeXML) {
        PersistorUtil.beginEncogObject("WeightedSynapse", writeXML, encogPersistedObject, false);
        WeightedSynapse weightedSynapse = (WeightedSynapse)encogPersistedObject;
        writeXML.beginTag(TAG_WEIGHTS);
        PersistorUtil.saveMatrix(weightedSynapse.getMatrix(), writeXML);
        writeXML.endTag();
        writeXML.endTag();
    }
}

