/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import org.encog.mathutil.matrices.Matrix;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.PersistError;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.BasicNeuralDataSetPersistor;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;
import org.encog.util.obj.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PersistorUtil {
    public static final String ATTRIBUTE_MATRIX_ROWS = "rows";
    public static final String ATTRIBUTE_MATRIX_COLS = "cols";
    public static final String ROW = "row";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public static void beginEncogObject(String string, WriteXML writeXML, EncogPersistedObject encogPersistedObject, boolean bl) {
        if (bl) {
            if (encogPersistedObject.getName() != null) {
                writeXML.addAttribute("name", encogPersistedObject.getName());
            }
            if (encogPersistedObject.getDescription() != null) {
                writeXML.addAttribute("description", encogPersistedObject.getDescription());
            } else {
                writeXML.addAttribute("description", "");
            }
        }
        writeXML.addAttribute("native", encogPersistedObject.getClass().getName());
        writeXML.addAttribute("id", "1");
        writeXML.beginTag(string);
    }

    public static Persistor createPersistor(String string) {
        Persistor persistor;
        try {
            if (string.equals("TrainingData")) {
                return new BasicNeuralDataSetPersistor();
            }
            String string2 = string + "Persistor";
            Class<?> clazz = Class.forName("org.encog.persist.persistors." + string2);
            Persistor persistor2 = (Persistor)clazz.newInstance();
            return persistor2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            persistor = null;
        }
        catch (InstantiationException instantiationException) {
            persistor = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            persistor = null;
        }
        if (persistor == null) {
            EncogPersistedObject encogPersistedObject;
            Class<?> clazz = ReflectionUtil.resolveEncogClass(string);
            try {
                encogPersistedObject = (EncogPersistedObject)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new PersistError(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new PersistError(illegalAccessException);
            }
            persistor = encogPersistedObject.createPersistor();
        }
        return persistor;
    }

    public static Matrix loadMatrix(ReadXML readXML) {
        int n = readXML.getTag().getAttributeInt(ATTRIBUTE_MATRIX_ROWS);
        int n2 = readXML.getTag().getAttributeInt(ATTRIBUTE_MATRIX_COLS);
        Matrix matrix = new Matrix(n, n2);
        int n3 = 0;
        String string = readXML.getTag().getName();
        while (readXML.readToTag() && !readXML.is(string, false)) {
            if (!readXML.is(ROW, true)) continue;
            String string2 = readXML.readTextToTag();
            double[] dArray = NumberList.fromList(CSVFormat.EG_FORMAT, string2);
            for (int i = 0; i < dArray.length; ++i) {
                matrix.set(n3, i, dArray[i]);
            }
            ++n3;
        }
        return matrix;
    }

    public static void saveMatrix(Matrix matrix, WriteXML writeXML) {
        writeXML.addAttribute(ATTRIBUTE_MATRIX_ROWS, "" + matrix.getRows());
        writeXML.addAttribute(ATTRIBUTE_MATRIX_COLS, "" + matrix.getCols());
        writeXML.beginTag("Matrix");
        for (int i = 0; i < matrix.getRows(); ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int j = 0; j < matrix.getCols(); ++j) {
                if (j > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(matrix.get(i, j));
            }
            writeXML.beginTag(ROW);
            writeXML.addText(stringBuilder.toString());
            writeXML.endTag();
        }
        writeXML.endTag();
    }

    private PersistorUtil() {
    }
}

