/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import org.encog.EncogError;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.PersistorUtil;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;
import org.encog.util.obj.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicLayerPersistor
implements Persistor {
    public static final String TAG_ACTIVATION = "activation";
    public static final String PROPERTY_NEURONS = "neurons";
    public static final String PROPERTY_THRESHOLD = "threshold";
    public static final String PROPERTY_BIAS_ACTIVATION = "biasActivation";
    public static final String PROPERTY_X = "x";
    public static final String PROPERTY_Y = "y";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public EncogPersistedObject load(ReadXML readXML) {
        Object object;
        double d = 1.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = null;
        ActivationFunction activationFunction = null;
        String string2 = readXML.getTag().getName();
        while (readXML.readToTag()) {
            if (readXML.is(TAG_ACTIVATION, true)) {
                readXML.readToTag();
                object = readXML.getTag().getName();
                activationFunction = BasicLayerPersistor.loadActivation((String)object, readXML);
                continue;
            }
            if (readXML.is(PROPERTY_NEURONS, true)) {
                n = readXML.readIntToTag();
                continue;
            }
            if (readXML.is(PROPERTY_THRESHOLD, true)) {
                string = readXML.readTextToTag();
                continue;
            }
            if (readXML.is(PROPERTY_X, true)) {
                n2 = readXML.readIntToTag();
                continue;
            }
            if (readXML.is(PROPERTY_Y, true)) {
                n3 = readXML.readIntToTag();
                continue;
            }
            if (readXML.is(PROPERTY_BIAS_ACTIVATION, true)) {
                d = Double.parseDouble(readXML.readTextToTag());
                continue;
            }
            if (!readXML.is(string2, false)) continue;
        }
        if (n > 0) {
            if (string == null) {
                object = new BasicLayer(activationFunction, false, n);
            } else {
                double[] dArray = NumberList.fromList(CSVFormat.EG_FORMAT, string);
                object = new BasicLayer(activationFunction, true, n);
                for (int i = 0; i < dArray.length; ++i) {
                    ((BasicLayer)object).setBiasWeight(i, dArray[i]);
                }
                ((BasicLayer)object).setBiasActivation(d);
            }
            ((BasicLayer)object).setX(n2);
            ((BasicLayer)object).setY(n3);
            return object;
        }
        return null;
    }

    public void save(EncogPersistedObject encogPersistedObject, WriteXML writeXML) {
        PersistorUtil.beginEncogObject("BasicLayer", writeXML, encogPersistedObject, false);
        BasicLayer basicLayer = (BasicLayer)encogPersistedObject;
        writeXML.addProperty(PROPERTY_NEURONS, basicLayer.getNeuronCount());
        writeXML.addProperty(PROPERTY_X, basicLayer.getX());
        writeXML.addProperty(PROPERTY_Y, basicLayer.getY());
        if (basicLayer.hasBias()) {
            StringBuilder stringBuilder = new StringBuilder();
            NumberList.toList(CSVFormat.EG_FORMAT, stringBuilder, basicLayer.getBiasWeights());
            writeXML.addProperty(PROPERTY_THRESHOLD, stringBuilder.toString());
        }
        writeXML.addProperty(PROPERTY_BIAS_ACTIVATION, basicLayer.getBiasActivation());
        BasicLayerPersistor.saveActivationFunction(basicLayer.getActivationFunction(), writeXML);
        writeXML.endTag();
    }

    public static void saveActivationFunction(ActivationFunction activationFunction, WriteXML writeXML) {
        if (activationFunction != null) {
            writeXML.beginTag(TAG_ACTIVATION);
            String[] stringArray = activationFunction.getParamNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                double d = activationFunction.getParams()[i];
                writeXML.addAttribute(string, "" + CSVFormat.EG_FORMAT.format(d, 10));
            }
            writeXML.beginTag(activationFunction.getClass().getSimpleName());
            writeXML.endTag();
            writeXML.endTag();
        }
    }

    public static ActivationFunction loadActivation(String string, ReadXML readXML) {
        try {
            Class<?> clazz = ReflectionUtil.resolveEncogClass(string);
            if (clazz == null) {
                throw new NeuralNetworkError("Unknown activation function type: " + string);
            }
            ActivationFunction activationFunction = (ActivationFunction)clazz.newInstance();
            for (String string2 : readXML.getTag().getAttributes().keySet()) {
                int n = -1;
                for (int i = 0; i < activationFunction.getParamNames().length; ++i) {
                    if (!string2.equalsIgnoreCase(activationFunction.getParamNames()[i])) continue;
                    n = i;
                    break;
                }
                if (n == -1) continue;
                String string3 = readXML.getTag().getAttributeValue(string2);
                double d = CSVFormat.EG_FORMAT.parse(string3);
                activationFunction.setParam(n, d);
            }
            return activationFunction;
        }
        catch (InstantiationException instantiationException) {
            throw new EncogError(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EncogError(illegalAccessException);
        }
    }
}

