/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.encog.parse.tags.Tag;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.DirectoryEntry;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.PersistError;
import org.encog.persist.Persistor;
import org.encog.persist.location.PersistenceLocation;
import org.encog.persist.persistors.PersistorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistReader {
    public static final String ATTRIBUTE_NAME = "name";
    public static final String TAG_OBJECTS = "Objects";
    private final ReadXML in;
    private final InputStream fileInput;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public PersistReader(PersistenceLocation persistenceLocation) {
        this.fileInput = persistenceLocation.createInputStream();
        this.in = new ReadXML(this.fileInput);
    }

    public boolean advance(String string) {
        this.advanceObjectsCollection();
        return this.advanceObjects(string);
    }

    private boolean advanceObjects(String string) {
        while (this.in.readToTag()) {
            Tag.Type type = this.in.getTag().getType();
            if (type != Tag.Type.BEGIN) continue;
            String string2 = this.in.getTag().getAttributeValue(ATTRIBUTE_NAME);
            if (string2 != null && string2.equals(string)) {
                return true;
            }
            this.skipObject();
        }
        return false;
    }

    public void advanceObjectsCollection() {
        while (this.in.readToTag()) {
            Tag.Type type = this.in.getTag().getType();
            if (type != Tag.Type.BEGIN || !this.in.getTag().getName().equals(TAG_OBJECTS)) continue;
            return;
        }
        if (this.logger.isErrorEnabled()) {
            this.logger.error("Can't find objects collection, invalid file.");
        }
        throw new PersistError("Can't find objects collection, invalid file.");
    }

    private boolean advanceToTag(String string) {
        while (this.in.readToTag()) {
            Tag.Type type = this.in.getTag().getType();
            if (type != Tag.Type.BEGIN) continue;
            if (this.in.getTag().getName().equals(string)) {
                return true;
            }
            this.skipObject();
        }
        return false;
    }

    public Set<DirectoryEntry> buildDirectory() {
        TreeSet<DirectoryEntry> treeSet = new TreeSet<DirectoryEntry>();
        this.advanceObjectsCollection();
        while (this.in.readToTag() && !this.in.is(TAG_OBJECTS, false)) {
            String string = this.in.getTag().getName();
            String string2 = this.in.getTag().getAttributeValue(ATTRIBUTE_NAME);
            String string3 = this.in.getTag().getAttributeValue("description");
            DirectoryEntry directoryEntry = new DirectoryEntry(string, string2, string3);
            treeSet.add(directoryEntry);
            this.skipObject();
        }
        return treeSet;
    }

    public void close() {
        try {
            this.fileInput.close();
        }
        catch (IOException iOException) {
            throw new PersistError(iOException);
        }
    }

    private void copyAttributes(WriteXML writeXML, Map<String, String> map) {
        for (String string : this.in.getTag().getAttributes().keySet()) {
            String string2 = this.in.getTag().getAttributeValue(string);
            if (map != null && map.containsKey(string)) {
                string2 = map.get(string);
            }
            writeXML.addAttribute(string, string2);
        }
    }

    private void copyXML(WriteXML writeXML, Map<String, String> map) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        this.copyAttributes(writeXML, map);
        String string = this.in.getTag().getName();
        writeXML.beginTag(string);
        while ((n = this.in.read()) != -1) {
            Tag.Type type = this.in.getTag().getType();
            if (n == 0) {
                if (type == Tag.Type.BEGIN) {
                    if (stringBuilder.length() > 0) {
                        writeXML.addText(stringBuilder.toString());
                        stringBuilder.setLength(0);
                    }
                    this.copyAttributes(writeXML, null);
                    writeXML.beginTag(this.in.getTag().getName());
                    ++n2;
                    continue;
                }
                if (type != Tag.Type.END) continue;
                if (stringBuilder.length() > 0) {
                    writeXML.addText(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
                if (n2 == 0) break;
                writeXML.endTag(this.in.getTag().getName());
                --n2;
                continue;
            }
            stringBuilder.append((char)n);
        }
        writeXML.endTag(string);
    }

    public ReadXML getXMLInput() {
        return this.in;
    }

    public Map<String, String> readHeader() {
        Map<String, String> map = null;
        if (this.advanceToTag("Document") && this.advanceToTag("Header")) {
            map = this.in.readPropertyBlock();
        }
        return map;
    }

    public boolean readNextTag(String string) {
        while (this.in.readToTag()) {
            Tag.Type type = this.in.getTag().getType();
            if (type != Tag.Type.BEGIN) continue;
            if (this.in.getTag().getName().equals(string)) {
                return true;
            }
            this.skipObject();
        }
        return false;
    }

    public String readNextText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.toString();
    }

    public EncogPersistedObject readObject(String string) {
        if (this.advance(string)) {
            String string2 = this.in.getTag().getName();
            Persistor persistor = PersistorUtil.createPersistor(string2);
            if (persistor == null) {
                throw new PersistError("Do not know how to load: " + string2);
            }
            return persistor.load(this.in);
        }
        return null;
    }

    public String readValue(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.readNextTag(string2)) continue;
            return null;
        }
        return this.readNextText(this.in.getTag().getName());
    }

    public void saveModified(WriteXML writeXML, String string, String string2, String string3) {
        this.advanceObjectsCollection();
        while (this.in.readToTag()) {
            Tag.Type type = this.in.getTag().getType();
            if (type != Tag.Type.BEGIN) continue;
            String string4 = this.in.getTag().getAttributeValue(ATTRIBUTE_NAME);
            if (string4.equals(string)) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(ATTRIBUTE_NAME, string2);
                hashMap.put("description", string3);
                this.copyXML(writeXML, hashMap);
                continue;
            }
            this.copyXML(writeXML, null);
        }
    }

    public void saveTo(WriteXML writeXML, String string) {
        this.advanceObjectsCollection();
        while (this.in.readToTag()) {
            Tag.Type type = this.in.getTag().getType();
            if (type != Tag.Type.BEGIN) continue;
            String string2 = this.in.getTag().getAttributeValue(ATTRIBUTE_NAME);
            if (string2.equals(string)) {
                this.skipObject();
                continue;
            }
            this.copyXML(writeXML, null);
        }
    }

    private void skipObject() {
        int n = 0;
        while (this.in.readToTag()) {
            Tag.Type type = this.in.getTag().getType();
            switch (type) {
                case END: {
                    if (n == 0) {
                        return;
                    }
                    --n;
                    break;
                }
                case BEGIN: {
                    ++n;
                }
            }
        }
    }
}

