/*
 * Decompiled with CFR 0.152.
 */
package org.encog.parse.tags.read;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.encog.parse.ParseError;
import org.encog.parse.tags.Tag;
import org.encog.parse.tags.read.ReadTags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadXML
extends ReadTags {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ReadXML(InputStream inputStream) {
        super(inputStream);
    }

    public boolean findTag(String string, boolean bl) {
        while (this.readToTag()) {
            if (!(bl ? this.getTag().getName().equals(string) && this.getTag().getType() == Tag.Type.BEGIN : this.getTag().getName().equals(string) && this.getTag().getType() == Tag.Type.END)) continue;
            return true;
        }
        return false;
    }

    public int readIntToTag() {
        try {
            String string = this.readTextToTag();
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)numberFormatException);
            }
            throw new ParseError(numberFormatException);
        }
    }

    public Map<String, String> readPropertyBlock() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.getTag().getName();
        while (this.readToTag() && (!this.getTag().getName().equals(string) || this.getTag().getType() != Tag.Type.END)) {
            String string2 = this.getTag().getName();
            String string3 = this.readTextToTag().trim();
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    public String readTextToTag() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        while (!bl) {
            int n = this.read();
            if (n == -1 || n == 0) {
                bl = true;
                continue;
            }
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }
}

