/*
 * Decompiled with CFR 0.152.
 */
package org.encog.parse.tags;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.encog.parse.ParseError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tag {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, String> attributes = new HashMap<String, String>();
    private String name = "";
    private Type type;

    public void clear() {
        this.attributes.clear();
        this.name = "";
        this.type = Type.BEGIN;
    }

    public Tag clone() {
        Tag tag = new Tag();
        tag.setName(this.getName());
        tag.setType(this.getType());
        for (String string : this.attributes.keySet()) {
            String string2 = this.attributes.get(string);
            tag.setAttribute(string, string2);
        }
        return tag;
    }

    public int getAttributeInt(String string) {
        try {
            String string2 = this.getAttributeValue(string);
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)numberFormatException);
            }
            throw new ParseError(numberFormatException);
        }
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttributeValue(String string) {
        return this.attributes.get(string);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public void setAttribute(String string, String string2) {
        this.attributes.put(string, string2);
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("<");
        if (this.type == Type.END) {
            stringBuilder.append("/");
        }
        stringBuilder.append(this.name);
        Set<String> set = this.attributes.keySet();
        for (String string : set) {
            String string2 = this.attributes.get(string);
            stringBuilder.append(' ');
            if (string2 == null) {
                stringBuilder.append("\"");
                stringBuilder.append(string);
                stringBuilder.append("\"");
                continue;
            }
            stringBuilder.append(string);
            stringBuilder.append("=\"");
            stringBuilder.append(string2);
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        BEGIN,
        END,
        COMMENT,
        CDATA;

    }
}

