/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.logic.SOMLogic;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOMPattern
implements NeuralNetworkPattern {
    private int inputNeurons;
    private int outputNeurons;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void addHiddenLayer(int n) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A SOM network does not have hidden layers.");
        }
        throw new PatternError("A SOM network does not have hidden layers.");
    }

    public void clear() {
    }

    public BasicNetwork generate() {
        BasicLayer basicLayer = new BasicLayer(new ActivationLinear(), false, this.inputNeurons);
        BasicLayer basicLayer2 = new BasicLayer(new ActivationLinear(), false, this.outputNeurons);
        int n = 50;
        BasicNetwork basicNetwork = new BasicNetwork(new SOMLogic());
        basicNetwork.addLayer(basicLayer);
        basicNetwork.addLayer(basicLayer2);
        basicLayer.setX(50);
        basicLayer2.setX(50);
        basicLayer.setY(n);
        basicLayer2.setY(n += 150);
        basicNetwork.getStructure().finalizeStructure();
        basicNetwork.reset();
        return basicNetwork;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A SOM network can't define an activation function.");
        }
        throw new PatternError("A SOM network can't define an activation function.");
    }

    public void setInputNeurons(int n) {
        this.inputNeurons = n;
    }

    public void setOutputNeurons(int n) {
        this.outputNeurons = n;
    }
}

