/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.mathutil.rbf.RBFEnum;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.layers.RadialBasisFunctionLayer;
import org.encog.neural.networks.synapse.SynapseType;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadialBasisPattern
implements NeuralNetworkPattern {
    public static final String RBF_LAYER = "RBF";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int inputNeurons = -1;
    private int outputNeurons = -1;
    private int hiddenNeurons = -1;

    public void addHiddenLayer(int n) {
        if (this.hiddenNeurons != -1) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("A RBF network usually has a single hidden layer.");
            }
            throw new PatternError("A RBF network usually has a single hidden layer.");
        }
        this.hiddenNeurons = n;
    }

    public void clear() {
        this.hiddenNeurons = -1;
    }

    public BasicNetwork generate() {
        BasicLayer basicLayer = new BasicLayer(new ActivationLinear(), false, this.inputNeurons);
        BasicLayer basicLayer2 = new BasicLayer(new ActivationLinear(), false, this.outputNeurons);
        BasicNetwork basicNetwork = new BasicNetwork();
        RadialBasisFunctionLayer radialBasisFunctionLayer = new RadialBasisFunctionLayer(this.hiddenNeurons);
        basicNetwork.addLayer(basicLayer);
        basicNetwork.addLayer(radialBasisFunctionLayer, SynapseType.Direct);
        basicNetwork.addLayer(basicLayer2);
        basicNetwork.getStructure().finalizeStructure();
        basicNetwork.reset();
        basicNetwork.tagLayer(RBF_LAYER, radialBasisFunctionLayer);
        int n = 50;
        basicLayer.setX(50);
        basicLayer.setY(n);
        radialBasisFunctionLayer.setX(50);
        radialBasisFunctionLayer.setY(n += 150);
        basicLayer2.setX(50);
        basicLayer2.setY(n += 150);
        double d = 2.0 / (double)radialBasisFunctionLayer.getNeuronCount();
        radialBasisFunctionLayer.setRBFCentersAndWidthsEqualSpacing(0.0, 1.0, RBFEnum.Gaussian, basicLayer.getNeuronCount(), d, true);
        return basicNetwork;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("Can't set the activation function for a radial basis function network.");
        }
        throw new PatternError("Can't set the activation function for a radial basis function network.");
    }

    public void setInputNeurons(int n) {
        this.inputNeurons = n;
    }

    public void setOutputNeurons(int n) {
        this.outputNeurons = n;
    }
}

