/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.layers.ContextLayer;
import org.encog.neural.networks.synapse.SynapseType;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JordanPattern
implements NeuralNetworkPattern {
    private int inputNeurons = -1;
    private int outputNeurons = -1;
    private int hiddenNeurons = -1;
    private ActivationFunction activation;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void addHiddenLayer(int n) {
        if (this.hiddenNeurons != -1) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("A Jordan neural network should have only one hidden layer.");
            }
            throw new PatternError("A Jordan neural network should have only one hidden layer.");
        }
        this.hiddenNeurons = n;
    }

    public void clear() {
        this.hiddenNeurons = -1;
    }

    public BasicNetwork generate() {
        BasicLayer basicLayer = new BasicLayer(this.activation, false, this.inputNeurons);
        BasicLayer basicLayer2 = new BasicLayer(this.activation, true, this.hiddenNeurons);
        BasicLayer basicLayer3 = new BasicLayer(this.activation, true, this.outputNeurons);
        ContextLayer contextLayer = new ContextLayer(this.outputNeurons);
        BasicNetwork basicNetwork = new BasicNetwork();
        basicNetwork.addLayer(basicLayer);
        basicNetwork.addLayer(basicLayer2);
        basicNetwork.addLayer(basicLayer3);
        basicLayer3.addNext(contextLayer, SynapseType.OneToOne);
        contextLayer.addNext(basicLayer2);
        int n = 50;
        basicLayer.setX(50);
        basicLayer.setY(n);
        basicLayer2.setX(50);
        basicLayer2.setY(n += 150);
        contextLayer.setX(300);
        contextLayer.setY(n);
        basicLayer3.setX(50);
        basicLayer3.setY(n += 150);
        basicNetwork.getStructure().finalizeStructure();
        basicNetwork.reset();
        return basicNetwork;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        this.activation = activationFunction;
    }

    public void setInputNeurons(int n) {
        this.inputNeurons = n;
    }

    public void setOutputNeurons(int n) {
        this.outputNeurons = n;
    }
}

