/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.logic.ART1Logic;
import org.encog.neural.networks.synapse.WeightedSynapse;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ART1Pattern
implements NeuralNetworkPattern {
    public static final String TAG_F1 = "F1";
    public static final String TAG_F2 = "F2";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int inputNeurons;
    private int outputNeurons;
    private double a1 = 1.0;
    private double b1 = 1.5;
    private double c1 = 5.0;
    private double d1 = 0.9;
    private double l = 3.0;
    private double vigilance = 0.9;

    public void addHiddenLayer(int n) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A ART1 network has no hidden layers.");
        }
        throw new PatternError("A ART1 network has no hidden layers.");
    }

    public void clear() {
        this.outputNeurons = 0;
        this.inputNeurons = 0;
    }

    public BasicNetwork generate() {
        BasicNetwork basicNetwork = new BasicNetwork(new ART1Logic());
        int n = 50;
        BasicLayer basicLayer = new BasicLayer(new ActivationLinear(), false, this.inputNeurons);
        BasicLayer basicLayer2 = new BasicLayer(new ActivationLinear(), false, this.outputNeurons);
        WeightedSynapse weightedSynapse = new WeightedSynapse(basicLayer, basicLayer2);
        WeightedSynapse weightedSynapse2 = new WeightedSynapse(basicLayer2, basicLayer);
        basicLayer.getNext().add(weightedSynapse);
        basicLayer2.getNext().add(weightedSynapse2);
        basicNetwork.tagLayer("INPUT", basicLayer);
        basicNetwork.tagLayer("OUTPUT", basicLayer2);
        basicNetwork.tagLayer(TAG_F1, basicLayer);
        basicNetwork.tagLayer(TAG_F2, basicLayer2);
        basicLayer.setX(50);
        basicLayer.setY(n);
        basicLayer2.setX(50);
        basicLayer2.setY(n += 150);
        basicNetwork.setProperty("A1", this.a1);
        basicNetwork.setProperty("B1", this.b1);
        basicNetwork.setProperty("C1", this.c1);
        basicNetwork.setProperty("D1", this.d1);
        basicNetwork.setProperty("L", this.l);
        basicNetwork.setProperty("VIGILANCE", this.vigilance);
        basicNetwork.getStructure().finalizeStructure();
        return basicNetwork;
    }

    public double getA1() {
        return this.a1;
    }

    public double getB1() {
        return this.b1;
    }

    public double getC1() {
        return this.c1;
    }

    public double getD1() {
        return this.d1;
    }

    public double getL() {
        return this.l;
    }

    public double getVigilance() {
        return this.vigilance;
    }

    public void setA1(double d) {
        this.a1 = d;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("Can't set the activation function for an ART1.");
        }
        throw new PatternError("Can't set the activation function for an ART1.");
    }

    public void setB1(double d) {
        this.b1 = d;
    }

    public void setC1(double d) {
        this.c1 = d;
    }

    public void setD1(double d) {
        this.d1 = d;
    }

    public void setInputNeurons(int n) {
        this.inputNeurons = n;
    }

    public void setL(double d) {
        this.l = d;
    }

    public void setOutputNeurons(int n) {
        this.outputNeurons = n;
    }

    public void setVigilance(double d) {
        this.vigilance = d;
    }
}

