/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.svd;

import org.encog.engine.network.rbf.RadialBasisFunction;

public class SVD {
    public static double svdfit(double[][] dArray, double[][] dArray2, double[][] dArray3, RadialBasisFunction[] radialBasisFunctionArray) {
        int n;
        int n2;
        double d = 1.0E-13;
        double[][] dArray4 = new double[dArray.length][radialBasisFunctionArray.length];
        double[][] dArray5 = new double[radialBasisFunctionArray.length][radialBasisFunctionArray.length];
        double[] dArray6 = new double[radialBasisFunctionArray.length];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < radialBasisFunctionArray.length; ++n) {
                dArray4[n2][n] = radialBasisFunctionArray[n].calculate(dArray[n2]);
            }
        }
        SVD.svdcmp(dArray4, dArray6, dArray5);
        double d2 = 0.0;
        for (n = 0; n < radialBasisFunctionArray.length; ++n) {
            if (!(dArray6[n] > d2)) continue;
            d2 = dArray6[n];
        }
        double d3 = d * d2;
        for (n = 0; n < radialBasisFunctionArray.length; ++n) {
            if (!(dArray6[n] < d3)) continue;
            dArray6[n] = 0.0;
        }
        SVD.svdbksb(dArray4, dArray6, dArray5, dArray2, dArray3);
        double d4 = 0.0;
        for (int i = 0; i < dArray2[0].length; ++i) {
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                double d5 = 0.0;
                for (n = 0; n < radialBasisFunctionArray.length; ++n) {
                    d5 += dArray3[n][i] * radialBasisFunctionArray[n].calculate(dArray[n2]);
                }
                double d6 = dArray2[n2][i] - d5;
                d4 += d6 * d6;
            }
        }
        return Math.sqrt(d4 / (double)(dArray2.length * dArray2[0].length));
    }

    public static void svdbksb(double[][] dArray, double[] dArray2, double[][] dArray3, double[][] dArray4, double[][] dArray5) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[] dArray6 = new double[n2];
        for (int i = 0; i < dArray4[0].length; ++i) {
            double d;
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                d = 0.0;
                if (dArray2[n3] != 0.0) {
                    for (int j = 0; j < n; ++j) {
                        d += dArray[j][n3] * dArray4[j][i];
                    }
                    d /= dArray2[n3];
                }
                dArray6[n3] = d;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                d = 0.0;
                for (int j = 0; j < n2; ++j) {
                    d += dArray3[n3][j] * dArray6[j];
                }
                dArray5[n3][i] = d;
            }
        }
    }

    public static void svdcmp(double[][] dArray, double[] dArray2, double[][] dArray3) {
        int n;
        double d;
        double d2;
        int n2;
        double d3;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = dArray.length;
        int n7 = dArray[0].length;
        double[] dArray4 = new double[n7];
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (n3 = 0; n3 < n7; ++n3) {
            n4 = n3 + 2;
            dArray4[n3] = d5 * d6;
            d5 = 0.0;
            d3 = 0.0;
            d6 = 0.0;
            if (n3 < n6) {
                for (n2 = n3; n2 < n6; ++n2) {
                    d5 += Math.abs(dArray[n2][n3]);
                }
                if (d5 != 0.0) {
                    for (n2 = n3; n2 < n6; ++n2) {
                        double[] dArray5 = dArray[n2];
                        int n8 = n3;
                        dArray5[n8] = dArray5[n8] / d5;
                        d3 += dArray[n2][n3] * dArray[n2][n3];
                    }
                    d2 = dArray[n3][n3];
                    d6 = -SVD.SIGN(Math.sqrt(d3), d2);
                    d = d2 * d6 - d3;
                    dArray[n3][n3] = d2 - d6;
                    for (n = n4 - 1; n < n7; ++n) {
                        d3 = 0.0;
                        for (n2 = n3; n2 < n6; ++n2) {
                            d3 += dArray[n2][n3] * dArray[n2][n];
                        }
                        d2 = d3 / d;
                        for (n2 = n3; n2 < n6; ++n2) {
                            double[] dArray6 = dArray[n2];
                            int n9 = n;
                            dArray6[n9] = dArray6[n9] + d2 * dArray[n2][n3];
                        }
                    }
                    for (n2 = n3; n2 < n6; ++n2) {
                        double[] dArray7 = dArray[n2];
                        int n10 = n3;
                        dArray7[n10] = dArray7[n10] * d5;
                    }
                }
            }
            dArray2[n3] = d5 * d6;
            d5 = 0.0;
            d3 = 0.0;
            d6 = 0.0;
            if (n3 + 1 <= n6 && n3 + 1 != n7) {
                for (n2 = n4 - 1; n2 < n7; ++n2) {
                    d5 += Math.abs(dArray[n3][n2]);
                }
                if (d5 != 0.0) {
                    for (n2 = n4 - 1; n2 < n7; ++n2) {
                        double[] dArray8 = dArray[n3];
                        int n11 = n2;
                        dArray8[n11] = dArray8[n11] / d5;
                        d3 += dArray[n3][n2] * dArray[n3][n2];
                    }
                    d2 = dArray[n3][n4 - 1];
                    d6 = -SVD.SIGN(Math.sqrt(d3), d2);
                    d = d2 * d6 - d3;
                    dArray[n3][n4 - 1] = d2 - d6;
                    for (n2 = n4 - 1; n2 < n7; ++n2) {
                        dArray4[n2] = dArray[n3][n2] / d;
                    }
                    for (n = n4 - 1; n < n6; ++n) {
                        d3 = 0.0;
                        for (n2 = n4 - 1; n2 < n7; ++n2) {
                            d3 += dArray[n][n2] * dArray[n3][n2];
                        }
                        for (n2 = n4 - 1; n2 < n7; ++n2) {
                            double[] dArray9 = dArray[n];
                            int n12 = n2;
                            dArray9[n12] = dArray9[n12] + d3 * dArray4[n2];
                        }
                    }
                    n2 = n4 - 1;
                    while (n2 < n7) {
                        double[] dArray10 = dArray[n3];
                        int n13 = n2++;
                        dArray10[n13] = dArray10[n13] * d5;
                    }
                }
            }
            d4 = SVD.MAX(d4, Math.abs(dArray2[n3]) + Math.abs(dArray4[n3]));
        }
        n3 = n7 - 1;
        while (n3 >= 0) {
            if (n3 < n7 - 1) {
                if (d6 != 0.0) {
                    for (n = n4; n < n7; ++n) {
                        dArray3[n][n3] = dArray[n3][n] / dArray[n3][n4] / d6;
                    }
                    for (n = n4; n < n7; ++n) {
                        d3 = 0.0;
                        for (n2 = n4; n2 < n7; ++n2) {
                            d3 += dArray[n3][n2] * dArray3[n2][n];
                        }
                        for (n2 = n4; n2 < n7; ++n2) {
                            double[] dArray11 = dArray3[n2];
                            int n14 = n;
                            dArray11[n14] = dArray11[n14] + d3 * dArray3[n2][n3];
                        }
                    }
                }
                for (n = n4; n < n7; ++n) {
                    dArray3[n][n3] = 0.0;
                    dArray3[n3][n] = 0.0;
                }
            }
            dArray3[n3][n3] = 1.0;
            d6 = dArray4[n3];
            n4 = n3--;
        }
        n3 = SVD.MIN(n6, n7) - 1;
        while (n3 >= 0) {
            n4 = n3 + 1;
            d6 = dArray2[n3];
            for (n = n4; n < n7; ++n) {
                dArray[n3][n] = 0.0;
            }
            if (d6 != 0.0) {
                d6 = 1.0 / d6;
                for (n = n4; n < n7; ++n) {
                    d3 = 0.0;
                    for (n2 = n4; n2 < n6; ++n2) {
                        d3 += dArray[n2][n3] * dArray[n2][n];
                    }
                    d2 = d3 / dArray[n3][n3] * d6;
                    for (n2 = n3; n2 < n6; ++n2) {
                        double[] dArray12 = dArray[n2];
                        int n15 = n;
                        dArray12[n15] = dArray12[n15] + d2 * dArray[n2][n3];
                    }
                }
                for (n = n3; n < n6; ++n) {
                    double[] dArray13 = dArray[n];
                    int n16 = n3;
                    dArray13[n16] = dArray13[n16] * d6;
                }
            } else {
                for (n = n3; n < n6; ++n) {
                    dArray[n][n3] = 0.0;
                }
            }
            double[] dArray14 = dArray[n3];
            int n17 = n3--;
            dArray14[n17] = dArray14[n17] + 1.0;
        }
        block27: for (n2 = n7 - 1; n2 >= 0; --n2) {
            for (int i = 0; i < 30; ++i) {
                double d7;
                double d8;
                double d9;
                boolean bl = true;
                for (n4 = n2; n4 >= 0; --n4) {
                    n5 = n4 - 1;
                    if (Math.abs(dArray4[n4]) + d4 == d4) {
                        bl = false;
                        break;
                    }
                    if (Math.abs(dArray2[n5]) + d4 == d4) break;
                }
                if (bl) {
                    d9 = 0.0;
                    d3 = 1.0;
                    for (n3 = n4; n3 < n2 + 1; ++n3) {
                        d2 = d3 * dArray4[n3];
                        dArray4[n3] = d9 * dArray4[n3];
                        if (Math.abs(d2) + d4 == d4) break;
                        d6 = dArray2[n3];
                        dArray2[n3] = d = SVD.pythag(d2, d6);
                        d = 1.0 / d;
                        d9 = d6 * d;
                        d3 = -d2 * d;
                        for (n = 0; n < n6; ++n) {
                            d8 = dArray[n][n5];
                            d7 = dArray[n][n3];
                            dArray[n][n5] = d8 * d9 + d7 * d3;
                            dArray[n][n3] = d7 * d9 - d8 * d3;
                        }
                    }
                }
                d7 = dArray2[n2];
                if (n4 == n2) {
                    if (!(d7 < 0.0)) continue block27;
                    dArray2[n2] = -d7;
                    for (n = 0; n < n7; ++n) {
                        dArray3[n][n2] = -dArray3[n][n2];
                    }
                    continue block27;
                }
                if (i == 29) {
                    // empty if block
                }
                double d10 = dArray2[n4];
                n5 = n2 - 1;
                d8 = dArray2[n5];
                d6 = dArray4[n5];
                d = dArray4[n2];
                d2 = ((d8 - d7) * (d8 + d7) + (d6 - d) * (d6 + d)) / (2.0 * d * d8);
                d6 = SVD.pythag(d2, 1.0);
                d2 = ((d10 - d7) * (d10 + d7) + d * (d8 / (d2 + SVD.SIGN(d6, d2)) - d)) / d10;
                d3 = 1.0;
                d9 = 1.0;
                for (n = n4; n <= n5; ++n) {
                    int n18;
                    n3 = n + 1;
                    d6 = dArray4[n3];
                    d8 = dArray2[n3];
                    d = d3 * d6;
                    d6 = d9 * d6;
                    dArray4[n] = d7 = SVD.pythag(d2, d);
                    d9 = d2 / d7;
                    d3 = d / d7;
                    d2 = d10 * d9 + d6 * d3;
                    d6 = d6 * d9 - d10 * d3;
                    d = d8 * d3;
                    d8 *= d9;
                    for (n18 = 0; n18 < n7; ++n18) {
                        d10 = dArray3[n18][n];
                        d7 = dArray3[n18][n3];
                        dArray3[n18][n] = d10 * d9 + d7 * d3;
                        dArray3[n18][n3] = d7 * d9 - d10 * d3;
                    }
                    dArray2[n] = d7 = SVD.pythag(d2, d);
                    if (d7 != 0.0) {
                        d7 = 1.0 / d7;
                        d9 = d2 * d7;
                        d3 = d * d7;
                    }
                    d2 = d9 * d6 + d3 * d8;
                    d10 = d9 * d8 - d3 * d6;
                    for (n18 = 0; n18 < n6; ++n18) {
                        d8 = dArray[n18][n];
                        d7 = dArray[n18][n3];
                        dArray[n18][n] = d8 * d9 + d7 * d3;
                        dArray[n18][n3] = d7 * d9 - d8 * d3;
                    }
                }
                dArray4[n4] = 0.0;
                dArray4[n2] = d2;
                dArray2[n2] = d10;
            }
        }
    }

    public static int MIN(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public static double MAX(double d, double d2) {
        return d > d2 ? d : d2;
    }

    public static double SIGN(double d, double d2) {
        return d2 >= 0.0 ? Math.abs(d) : -Math.abs(d);
    }

    public static double pythag(double d, double d2) {
        double d3;
        double d4 = Math.abs(d);
        if (d4 > (d3 = Math.abs(d2))) {
            return d4 * Math.sqrt(1.0 + d3 / d4 * (d3 / d4));
        }
        return d3 == 0.0 ? 0.0 : d3 * Math.sqrt(1.0 + d4 / d3 * (d4 / d3));
    }
}

