/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.propagation.manhattan;

import org.encog.engine.network.train.prop.OpenCLTrainingProfile;
import org.encog.engine.network.train.prop.TrainFlatNetworkManhattan;
import org.encog.engine.network.train.prop.TrainFlatNetworkOpenCL;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.LearningRate;
import org.encog.neural.networks.training.propagation.Propagation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManhattanPropagation
extends Propagation
implements LearningRate {
    static final double DEFAULT_ZERO_TOLERANCE = 0.001;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ManhattanPropagation(BasicNetwork basicNetwork, NeuralDataSet neuralDataSet, double d) {
        this(basicNetwork, neuralDataSet, null, d);
    }

    public ManhattanPropagation(BasicNetwork basicNetwork, NeuralDataSet neuralDataSet, OpenCLTrainingProfile openCLTrainingProfile, double d) {
        super(basicNetwork, neuralDataSet);
        if (openCLTrainingProfile == null) {
            this.setFlatTraining(new TrainFlatNetworkManhattan(basicNetwork.getStructure().getFlat(), this.getTraining(), d));
        } else {
            TrainFlatNetworkOpenCL trainFlatNetworkOpenCL = new TrainFlatNetworkOpenCL(basicNetwork.getStructure().getFlat(), this.getTraining(), openCLTrainingProfile);
            trainFlatNetworkOpenCL.learnManhattan(d);
            this.setFlatTraining(trainFlatNetworkOpenCL);
        }
    }

    public double getLearningRate() {
        return ((TrainFlatNetworkManhattan)this.getFlatTraining()).getLearningRate();
    }

    public void setLearningRate(double d) {
        ((TrainFlatNetworkManhattan)this.getFlatTraining()).setLearningRate(d);
    }
}

