/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.neat;

import org.encog.neural.networks.synapse.neat.NEATNeuronType;
import org.encog.neural.networks.training.neat.NEATInnovationType;
import org.encog.neural.networks.training.neat.NEATNeuronGene;
import org.encog.persist.annotations.EGAttribute;
import org.encog.solve.genetic.innovation.BasicInnovation;

public class NEATInnovation
extends BasicInnovation {
    @EGAttribute
    private long fromNeuronID;
    @EGAttribute
    private NEATInnovationType innovationType;
    @EGAttribute
    private long neuronID;
    @EGAttribute
    private NEATNeuronType neuronType;
    @EGAttribute
    private double splitX;
    @EGAttribute
    private double splitY;
    @EGAttribute
    private long toNeuronID;

    public NEATInnovation() {
    }

    public NEATInnovation(long l, long l2, NEATInnovationType nEATInnovationType, long l3) {
        this.fromNeuronID = l;
        this.toNeuronID = l2;
        this.innovationType = nEATInnovationType;
        this.setInnovationID(l3);
        this.neuronID = -1L;
        this.splitX = 0.0;
        this.splitY = 0.0;
        this.neuronType = NEATNeuronType.None;
    }

    public NEATInnovation(long l, long l2, NEATInnovationType nEATInnovationType, long l3, NEATNeuronType nEATNeuronType, double d, double d2) {
        this.fromNeuronID = l;
        this.toNeuronID = l2;
        this.innovationType = nEATInnovationType;
        this.setInnovationID(l3);
        this.neuronType = nEATNeuronType;
        this.splitX = d;
        this.splitY = d2;
        this.neuronID = 0L;
    }

    public NEATInnovation(NEATNeuronGene nEATNeuronGene, long l, long l2) {
        this.neuronID = l2;
        this.setInnovationID(l);
        this.splitX = nEATNeuronGene.getSplitX();
        this.splitY = nEATNeuronGene.getSplitY();
        this.neuronType = nEATNeuronGene.getNeuronType();
        this.innovationType = NEATInnovationType.NewNeuron;
        this.fromNeuronID = -1L;
        this.toNeuronID = -1L;
    }

    public long getFromNeuronID() {
        return this.fromNeuronID;
    }

    public NEATInnovationType getInnovationType() {
        return this.innovationType;
    }

    public long getNeuronID() {
        return this.neuronID;
    }

    public NEATNeuronType getNeuronType() {
        return this.neuronType;
    }

    public double getSplitX() {
        return this.splitX;
    }

    public double getSplitY() {
        return this.splitY;
    }

    public long getToNeuronID() {
        return this.toNeuronID;
    }

    public void setNeuronID(long l) {
        this.neuronID = l;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[NeatInnovation:type=");
        switch (this.innovationType) {
            case NewLink: {
                stringBuilder.append("link");
                break;
            }
            case NewNeuron: {
                stringBuilder.append("neuron");
            }
        }
        stringBuilder.append(",from=");
        stringBuilder.append(this.fromNeuronID);
        stringBuilder.append(",to=");
        stringBuilder.append(this.toNeuronID);
        stringBuilder.append(",splitX=");
        stringBuilder.append(this.splitX);
        stringBuilder.append(",splitY=");
        stringBuilder.append(this.splitY);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

