/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.genetic;

import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.structure.NetworkCODEC;
import org.encog.neural.networks.training.genetic.NeuralGeneticAlgorithm;
import org.encog.solve.genetic.genes.DoubleGene;
import org.encog.solve.genetic.genome.BasicGenome;
import org.encog.solve.genetic.genome.Chromosome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeuralGenome
extends BasicGenome {
    private final Chromosome networkChromosome;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public NeuralGenome(NeuralGeneticAlgorithm neuralGeneticAlgorithm, BasicNetwork basicNetwork) {
        super(neuralGeneticAlgorithm.getGenetic());
        this.setOrganism(basicNetwork);
        this.networkChromosome = new Chromosome();
        int n = basicNetwork.getStructure().calculateSize();
        for (int i = 0; i < n; ++i) {
            DoubleGene doubleGene = new DoubleGene();
            this.networkChromosome.getGenes().add(doubleGene);
        }
        this.getChromosomes().add(this.networkChromosome);
        this.encode();
    }

    public void decode() {
        double[] dArray = new double[this.networkChromosome.getGenes().size()];
        for (int i = 0; i < dArray.length; ++i) {
            DoubleGene doubleGene = (DoubleGene)this.networkChromosome.getGenes().get(i);
            dArray[i] = doubleGene.getValue();
        }
        NetworkCODEC.arrayToNetwork(dArray, (BasicNetwork)this.getOrganism());
    }

    public void encode() {
        double[] dArray = NetworkCODEC.networkToArray((BasicNetwork)this.getOrganism());
        for (int i = 0; i < dArray.length; ++i) {
            ((DoubleGene)this.networkChromosome.getGene(i)).setValue(dArray[i]);
        }
    }
}

