/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.cpn;

import org.encog.neural.data.NeuralData;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.synapse.Synapse;
import org.encog.neural.networks.training.TrainingError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindCPN {
    private final Layer inputLayer;
    private final Layer instarLayer;
    private final Layer outstarLayer;
    private final Synapse instarSynapse;
    private final Synapse outstarSynapse;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public FindCPN(BasicNetwork basicNetwork) {
        if (basicNetwork.getStructure().getLayers().size() != 3) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("A CPN network must have exactly 3 layers");
            }
            throw new TrainingError("A CPN network must have exactly 3 layers");
        }
        this.inputLayer = basicNetwork.getLayer("INPUT");
        this.outstarLayer = basicNetwork.getLayer("OUTSTAR");
        this.instarLayer = basicNetwork.getLayer("INSTAR");
        if (this.outstarLayer == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Can't find an OUTSTAR layer, this is required.");
            }
            throw new TrainingError("Can't find an OUTSTAR layer, this is required.");
        }
        if (this.instarLayer == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Can't find an OUTSTAR layer, this is required.");
            }
            throw new TrainingError("Can't find an OUTSTAR layer, this is required.");
        }
        this.instarSynapse = this.inputLayer.getNext().iterator().next();
        this.outstarSynapse = this.instarLayer.getNext().iterator().next();
    }

    public Layer getInputLayer() {
        return this.inputLayer;
    }

    public Layer getInstarLayer() {
        return this.instarLayer;
    }

    public Synapse getInstarSynapse() {
        return this.instarSynapse;
    }

    public Layer getOutstarLayer() {
        return this.outstarLayer;
    }

    public Synapse getOutstarSynapse() {
        return this.outstarSynapse;
    }

    public int winner(NeuralData neuralData) {
        int n = -1;
        for (int i = 0; i < neuralData.size(); ++i) {
            if (n != -1 && !(neuralData.getData(i) > neuralData.getData(n))) continue;
            n = i;
        }
        return n;
    }
}

