/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.concurrent.jobs;

import java.util.ArrayList;
import java.util.List;
import org.encog.engine.network.train.prop.OpenCLTrainingProfile;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.Strategy;
import org.encog.neural.networks.training.Train;
import org.encog.neural.networks.training.strategy.end.EndTrainingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TrainingJob {
    private BasicNetwork network;
    private NeuralDataSet training;
    private final List<Strategy> strategies = new ArrayList<Strategy>();
    private boolean loadToMemory;
    private Train train;
    private Throwable error;
    private int iterationsPer;
    private double localRatio;
    private int globalRatio;
    private double segmentationRatio;

    public TrainingJob(BasicNetwork basicNetwork, NeuralDataSet neuralDataSet, boolean bl) {
        this.network = basicNetwork;
        this.training = neuralDataSet;
        this.loadToMemory = bl;
        this.iterationsPer = 1;
        this.localRatio = 1.0;
        this.globalRatio = 1;
        this.segmentationRatio = 1.0;
    }

    public abstract void createTrainer(OpenCLTrainingProfile var1, boolean var2);

    public Throwable getError() {
        return this.error;
    }

    public BasicNetwork getNetwork() {
        return this.network;
    }

    public List<Strategy> getStrategies() {
        return this.strategies;
    }

    public Train getTrain() {
        return this.train;
    }

    public NeuralDataSet getTraining() {
        return this.training;
    }

    public boolean isLoadToMemory() {
        return this.loadToMemory;
    }

    public void setError(Throwable throwable) {
        this.error = throwable;
    }

    public void setLoadToMemory(boolean bl) {
        this.loadToMemory = bl;
    }

    public void setNetwork(BasicNetwork basicNetwork) {
        this.network = basicNetwork;
    }

    public void setTrain(Train train) {
        this.train = train;
    }

    public void setTraining(NeuralDataSet neuralDataSet) {
        this.training = neuralDataSet;
    }

    public boolean shouldContinue() {
        for (Strategy strategy : this.train.getStrategies()) {
            EndTrainingStrategy endTrainingStrategy;
            if (!(strategy instanceof EndTrainingStrategy) || !(endTrainingStrategy = (EndTrainingStrategy)strategy).shouldStop()) continue;
            return false;
        }
        return true;
    }

    public int getIterationsPer() {
        return this.iterationsPer;
    }

    public void setIterationsPer(int n) {
        this.iterationsPer = n;
    }

    public double getLocalRatio() {
        return this.localRatio;
    }

    public void setLocalRatio(double d) {
        this.localRatio = d;
    }

    public int getGlobalRatio() {
        return this.globalRatio;
    }

    public void setGlobalRatio(int n) {
        this.globalRatio = n;
    }

    public double getSegmentationRatio() {
        return this.segmentationRatio;
    }

    public void setSegmentationRatio(double d) {
        this.segmentationRatio = d;
    }
}

