/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.concurrent.jobs;

import org.encog.engine.network.train.prop.OpenCLTrainingProfile;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.Strategy;
import org.encog.neural.networks.training.concurrent.jobs.TrainingJob;
import org.encog.neural.networks.training.propagation.back.Backpropagation;

public class BPROPJob
extends TrainingJob {
    private double learningRate;
    private double momentum;

    public BPROPJob(BasicNetwork basicNetwork, NeuralDataSet neuralDataSet, boolean bl, double d, double d2) {
        this(basicNetwork, neuralDataSet, bl, d, d2, 1.0, 1, 1.0, 1);
    }

    public BPROPJob(BasicNetwork basicNetwork, NeuralDataSet neuralDataSet, boolean bl, double d, double d2, double d3, int n, double d4, int n2) {
        super(basicNetwork, neuralDataSet, bl);
        this.learningRate = d;
        this.momentum = d2;
        this.setLocalRatio(d3);
        this.setGlobalRatio(n);
        this.setSegmentationRatio(d4);
        this.setIterationsPer(n2);
    }

    public void createTrainer(OpenCLTrainingProfile openCLTrainingProfile, boolean bl) {
        Backpropagation backpropagation = new Backpropagation(this.getNetwork(), this.getTraining(), openCLTrainingProfile, this.getLearningRate(), this.getMomentum());
        if (bl) {
            backpropagation.setNumThreads(1);
        } else {
            backpropagation.setNumThreads(0);
        }
        for (Strategy strategy : this.getStrategies()) {
            backpropagation.addStrategy(strategy);
        }
        this.setTrain(backpropagation);
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public double getMomentum() {
        return this.momentum;
    }

    public void setLearningRate(double d) {
        this.learningRate = d;
    }

    public void setMomentum(double d) {
        this.momentum = d;
    }
}

