/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.synapse.neat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationSigmoid;
import org.encog.mathutil.matrices.Matrix;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.networks.ContextClearable;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.synapse.Synapse;
import org.encog.neural.networks.synapse.SynapseType;
import org.encog.neural.networks.synapse.neat.NEATLink;
import org.encog.neural.networks.synapse.neat.NEATNeuron;
import org.encog.neural.networks.synapse.neat.NEATNeuronType;
import org.encog.persist.EncogCollection;
import org.encog.persist.Persistor;
import org.encog.persist.annotations.EGAttribute;
import org.encog.persist.annotations.EGIgnore;
import org.encog.persist.persistors.generic.GenericPersistor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NEATSynapse
implements Synapse,
ContextClearable,
Serializable {
    private static final long serialVersionUID = 3660295468309926508L;
    private ActivationFunction activationFunction;
    @EGIgnore
    private Layer fromLayer;
    @EGAttribute
    private int networkDepth;
    private final List<NEATNeuron> neurons = new ArrayList<NEATNeuron>();
    @EGAttribute
    private boolean snapshot = false;
    @EGIgnore
    private Layer toLayer;

    public NEATSynapse() {
    }

    public NEATSynapse(BasicLayer basicLayer, BasicLayer basicLayer2, List<NEATNeuron> list, ActivationFunction activationFunction, int n) {
        this.fromLayer = basicLayer;
        this.toLayer = basicLayer2;
        this.neurons.addAll(list);
        this.networkDepth = n;
        this.activationFunction = activationFunction;
    }

    public NEATSynapse(Layer layer, Layer layer2) {
        this.fromLayer = layer;
        this.toLayer = layer2;
        this.networkDepth = 0;
        this.activationFunction = new ActivationSigmoid();
    }

    @Override
    public void clearContext() {
        for (NEATNeuron nEATNeuron : this.neurons) {
            nEATNeuron.setOutput(0.0);
        }
    }

    @Override
    public Object clone() {
        return null;
    }

    @Override
    public NeuralData compute(NeuralData neuralData) {
        BasicNeuralData basicNeuralData = new BasicNeuralData(this.getToNeuronCount());
        if (this.neurons.size() == 0) {
            throw new NeuralNetworkError("This network has not been evolved yet, it has no neurons in the NEAT synapse.");
        }
        int n = 1;
        if (this.snapshot) {
            n = this.networkDepth;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            int n3 = 0;
            basicNeuralData.clear();
            while (this.neurons.get(n3).getNeuronType() == NEATNeuronType.Input) {
                this.neurons.get(n3).setOutput(neuralData.getData(n3));
                ++n3;
            }
            this.neurons.get(n3++).setOutput(1.0);
            while (n3 < this.neurons.size()) {
                NEATNeuron nEATNeuron = this.neurons.get(n3);
                double d = 0.0;
                for (NEATLink nEATLink : nEATNeuron.getInboundLinks()) {
                    double d2 = nEATLink.getWeight();
                    double d3 = nEATLink.getFromNeuron().getOutput();
                    d += d2 * d3;
                }
                Object object = new double[1];
                object[0] = d / nEATNeuron.getActivationResponse();
                this.activationFunction.activationFunction((double[])object, 0, ((Object)object).length);
                this.neurons.get(n3).setOutput((double)object[0]);
                if (nEATNeuron.getNeuronType() == NEATNeuronType.Output) {
                    basicNeuralData.setData(n2++, nEATNeuron.getOutput());
                }
                ++n3;
            }
        }
        return basicNeuralData;
    }

    @Override
    public Persistor createPersistor() {
        return new GenericPersistor(NEATSynapse.class);
    }

    public ActivationFunction getActivationFunction() {
        return this.activationFunction;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Layer getFromLayer() {
        return this.fromLayer;
    }

    @Override
    public int getFromNeuronCount() {
        return this.fromLayer.getNeuronCount();
    }

    @Override
    public Matrix getMatrix() {
        return null;
    }

    @Override
    public int getMatrixSize() {
        return 0;
    }

    @Override
    public String getName() {
        return null;
    }

    public int getNetworkDepth() {
        return this.networkDepth;
    }

    public List<NEATNeuron> getNeurons() {
        return this.neurons;
    }

    @Override
    public Layer getToLayer() {
        return this.toLayer;
    }

    @Override
    public int getToNeuronCount() {
        return this.toLayer.getNeuronCount();
    }

    @Override
    public SynapseType getType() {
        return null;
    }

    @Override
    public boolean isSelfConnected() {
        return false;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    @Override
    public boolean isTeachable() {
        return false;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
    }

    @Override
    public void setDescription(String string) {
    }

    @Override
    public void setFromLayer(Layer layer) {
        this.fromLayer = layer;
    }

    @Override
    public void setMatrix(Matrix matrix) {
        throw new NeuralNetworkError("Neat synapse cannot have a simple matrix.");
    }

    @Override
    public void setName(String string) {
    }

    public void setSnapshot(boolean bl) {
        this.snapshot = bl;
    }

    @Override
    public void setToLayer(Layer layer) {
        this.toLayer = layer;
    }

    @Override
    public EncogCollection getCollection() {
        return null;
    }

    @Override
    public void setCollection(EncogCollection encogCollection) {
    }
}

