/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.synapse;

import org.encog.mathutil.matrices.Matrix;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.synapse.BasicSynapse;
import org.encog.neural.networks.synapse.SynapseType;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.WeightlessSynapsePersistor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightlessSynapse
extends BasicSynapse {
    private static final long serialVersionUID = -1899517385166651263L;
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public WeightlessSynapse() {
    }

    public WeightlessSynapse(Layer layer, Layer layer2) {
        this.setFromLayer(layer);
        this.setToLayer(layer2);
    }

    public Object clone() {
        WeightlessSynapse weightlessSynapse = new WeightlessSynapse();
        weightlessSynapse.setMatrix(this.getMatrix().clone());
        return weightlessSynapse;
    }

    public NeuralData compute(NeuralData neuralData) {
        int n;
        BasicNeuralData basicNeuralData = new BasicNeuralData(this.getToNeuronCount());
        double d = 0.0;
        for (n = 0; n < neuralData.size(); ++n) {
            d += neuralData.getData(n);
        }
        for (n = 0; n < this.getToNeuronCount(); ++n) {
            basicNeuralData.setData(n, d);
        }
        return basicNeuralData;
    }

    public Persistor createPersistor() {
        return new WeightlessSynapsePersistor();
    }

    public Matrix getMatrix() {
        return null;
    }

    public int getMatrixSize() {
        return 0;
    }

    public SynapseType getType() {
        return SynapseType.Weighted;
    }

    public boolean isTeachable() {
        return false;
    }

    public void setMatrix(Matrix matrix) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("Can't set the matrix for a WeightlessSynapse");
        }
        throw new NeuralNetworkError("Can't set the matrix for a WeightlessSynapse");
    }
}

