/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.svm;

import org.encog.mathutil.libsvm.svm;
import org.encog.mathutil.libsvm.svm_model;
import org.encog.mathutil.libsvm.svm_node;
import org.encog.mathutil.libsvm.svm_parameter;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.NeuralOutputHolder;
import org.encog.neural.networks.svm.KernelType;
import org.encog.neural.networks.svm.SVMType;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.SVMNetworkPersistor;

public class SVMNetwork
extends BasicNetwork {
    private svm_model[] models;
    private svm_parameter[] params;
    private int inputCount;
    private int outputCount;
    private KernelType kernelType;
    private SVMType svmType;

    public SVMNetwork(int n, int n2, SVMType sVMType, KernelType kernelType) {
        this.inputCount = n;
        this.outputCount = n2;
        this.kernelType = kernelType;
        this.svmType = sVMType;
        this.models = new svm_model[n2];
        this.params = new svm_parameter[n2];
        for (int i = 0; i < n2; ++i) {
            this.params[i] = new svm_parameter();
            switch (sVMType) {
                case SupportVectorClassification: {
                    this.params[i].svm_type = 0;
                    break;
                }
                case NewSupportVectorClassification: {
                    this.params[i].svm_type = 1;
                    break;
                }
                case SupportVectorOneClass: {
                    this.params[i].svm_type = 2;
                    break;
                }
                case EpsilonSupportVectorRegression: {
                    this.params[i].svm_type = 3;
                    break;
                }
                case NewSupportVectorRegression: {
                    this.params[i].svm_type = 4;
                }
            }
            switch (kernelType) {
                case Linear: {
                    this.params[i].kernel_type = 0;
                    break;
                }
                case Poly: {
                    this.params[i].kernel_type = 1;
                    break;
                }
                case RadialBasisFunction: {
                    this.params[i].kernel_type = 2;
                    break;
                }
                case Sigmoid: {
                    this.params[i].kernel_type = 3;
                    break;
                }
                case Precomputed: {
                    this.params[i].kernel_type = 4;
                }
            }
            this.params[i].kernel_type = 2;
            this.params[i].degree = 3;
            this.params[i].coef0 = 0.0;
            this.params[i].nu = 0.5;
            this.params[i].cache_size = 100.0;
            this.params[i].C = 1.0;
            this.params[i].eps = 0.001;
            this.params[i].p = 0.1;
            this.params[i].shrinking = 1;
            this.params[i].probability = 0;
            this.params[i].nr_weight = 0;
            this.params[i].weight_label = new int[0];
            this.params[i].weight = new double[0];
            this.params[i].gamma = 1.0 / (double)n;
        }
    }

    public SVMNetwork(int n, int n2, boolean bl) {
        this(n, n2, bl ? SVMType.EpsilonSupportVectorRegression : SVMType.SupportVectorClassification, KernelType.RadialBasisFunction);
    }

    public NeuralData compute(NeuralData neuralData) {
        BasicNeuralData basicNeuralData = new BasicNeuralData(this.outputCount);
        svm_node[] svm_nodeArray = this.makeSparse(neuralData);
        for (int i = 0; i < this.outputCount; ++i) {
            double d = svm.svm_predict(this.models[i], svm_nodeArray);
            basicNeuralData.setData(i, d);
        }
        return basicNeuralData;
    }

    public NeuralData compute(NeuralData neuralData, NeuralOutputHolder neuralOutputHolder) {
        neuralOutputHolder.setOutput(this.compute(neuralData));
        return neuralOutputHolder.getOutput();
    }

    public svm_node[] makeSparse(NeuralData neuralData) {
        svm_node[] svm_nodeArray = new svm_node[neuralData.size()];
        for (int i = 0; i < neuralData.size(); ++i) {
            svm_nodeArray[i] = new svm_node();
            svm_nodeArray[i].index = i + 1;
            svm_nodeArray[i].value = neuralData.getData(i);
        }
        return svm_nodeArray;
    }

    public Persistor createPersistor() {
        return new SVMNetworkPersistor();
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    public svm_model[] getModels() {
        return this.models;
    }

    public svm_parameter[] getParams() {
        return this.params;
    }

    public KernelType getKernelType() {
        return this.kernelType;
    }

    public SVMType getSvmType() {
        return this.svmType;
    }
}

