/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.structure;

import java.util.Comparator;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.structure.CalculateDepth;
import org.encog.neural.networks.structure.NeuralStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerComparator
implements Comparator<Layer> {
    private final NeuralStructure structure;
    private final CalculateDepth depth;
    private final Layer inputLayer;
    private final Layer outputLayer;

    public LayerComparator(NeuralStructure neuralStructure) {
        this.structure = neuralStructure;
        this.depth = new CalculateDepth(neuralStructure.getNetwork());
        this.inputLayer = this.structure.getNetwork().getLayer("INPUT");
        this.outputLayer = this.structure.getNetwork().getLayer("OUTPUT");
    }

    @Override
    public int compare(Layer layer, Layer layer2) {
        int n = this.depth.getDepth(layer);
        int n2 = this.depth.getDepth(layer2);
        if (layer == layer2) {
            return 0;
        }
        if (layer == this.outputLayer || layer2 == this.inputLayer) {
            return -1;
        }
        if (layer2 == this.outputLayer || layer == this.inputLayer) {
            return 1;
        }
        if (n != n2) {
            return n - n2;
        }
        return layer.getID() - layer2.getID();
    }

    public boolean equal(Layer layer, Layer layer2) {
        return layer == layer2;
    }
}

