/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.structure;

import java.util.ArrayList;
import org.encog.engine.util.EngineArray;
import org.encog.engine.util.Format;
import org.encog.mathutil.NumericRange;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.synapse.Synapse;

public class AnalyzeNetwork {
    private final NumericRange weights;
    private final NumericRange bias;
    private final NumericRange weightsAndBias;
    private final int disabledConnections;
    private final int totalConnections;
    private final double[] allValues;
    private final double[] weightValues;
    private final double[] biasValues;

    public AnalyzeNetwork(BasicNetwork basicNetwork) {
        int n;
        int n2 = 0;
        int n3 = 0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        for (Layer encogPersistedObject : basicNetwork.getStructure().getLayers()) {
            if (!encogPersistedObject.hasBias()) continue;
            for (n = 0; n < encogPersistedObject.getNeuronCount(); ++n) {
                arrayList.add(encogPersistedObject.getBiasWeight(n));
                arrayList3.add(encogPersistedObject.getBiasWeight(n));
            }
        }
        for (Synapse synapse : basicNetwork.getStructure().getSynapses()) {
            if (synapse.getMatrixSize() <= 0) continue;
            for (n = 0; n < synapse.getFromNeuronCount(); ++n) {
                for (int i = 0; i < synapse.getToNeuronCount(); ++i) {
                    if (basicNetwork.isConnected(synapse, n, i)) {
                        double d = synapse.getMatrix().get(n, i);
                        arrayList2.add(d);
                        arrayList3.add(d);
                    } else {
                        ++n2;
                    }
                    ++n3;
                }
            }
        }
        this.disabledConnections = n2;
        this.totalConnections = n3;
        this.weights = new NumericRange(arrayList2);
        this.bias = new NumericRange(arrayList);
        this.weightsAndBias = new NumericRange(arrayList3);
        this.weightValues = EngineArray.listToDouble(arrayList2);
        this.allValues = EngineArray.listToDouble(arrayList3);
        this.biasValues = EngineArray.listToDouble(arrayList);
    }

    public double[] getAllValues() {
        return this.allValues;
    }

    public NumericRange getBias() {
        return this.bias;
    }

    public double[] getBiasValues() {
        return this.biasValues;
    }

    public int getDisabledConnections() {
        return this.disabledConnections;
    }

    public int getTotalConnections() {
        return this.totalConnections;
    }

    public NumericRange getWeights() {
        return this.weights;
    }

    public NumericRange getWeightsAndBias() {
        return this.weightsAndBias;
    }

    public double[] getWeightValues() {
        return this.weightValues;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("All Values : ");
        stringBuilder.append(this.weightsAndBias.toString());
        stringBuilder.append("\n");
        stringBuilder.append("Bias : ");
        stringBuilder.append(this.bias.toString());
        stringBuilder.append("\n");
        stringBuilder.append("Weights    : ");
        stringBuilder.append(this.weights.toString());
        stringBuilder.append("\n");
        stringBuilder.append("Disabled   : ");
        stringBuilder.append(Format.formatInteger(this.disabledConnections));
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

