/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.layers;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationTANH;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.networks.ContextClearable;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.ContextLayerPersistor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextLayer
extends BasicLayer
implements ContextClearable {
    public static final String ERROR = "Bias is not suppoted for a contextlayer.";
    private static final long serialVersionUID = -5588659547177460637L;
    private final NeuralData context;
    private int flatContextIndex = -1;
    private static final transient Logger LOGGER = LoggerFactory.getLogger(ContextLayer.class);

    public ContextLayer() {
        this(1);
    }

    public ContextLayer(ActivationFunction activationFunction, int n) {
        super(activationFunction, false, n);
        this.context = new BasicNeuralData(n);
    }

    public ContextLayer(int n) {
        this(new ActivationTANH(), n);
    }

    public Persistor createPersistor() {
        return new ContextLayerPersistor();
    }

    public NeuralData getContext() {
        return this.context;
    }

    public void process(NeuralData neuralData) {
        double[] dArray = neuralData.getData();
        double[] dArray2 = this.context.getData();
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Updated ContextLayer to {}", (Object)neuralData);
        }
    }

    public NeuralData recur() {
        return this.context;
    }

    public void clearContext() {
        for (int i = 0; i < this.context.size(); ++i) {
            this.context.setData(i, 0.0);
        }
    }

    public double[] getBiasWeights() {
        throw new NeuralNetworkError(ERROR);
    }

    public double getBiasWeight(int n) {
        throw new NeuralNetworkError(ERROR);
    }

    public void setBiasWeights(double[] dArray) {
        throw new NeuralNetworkError(ERROR);
    }

    public void setBiasWeight(int n, double d) {
        throw new NeuralNetworkError(ERROR);
    }

    public int getFlatContextIndex() {
        return this.flatContextIndex;
    }

    public void setFlatContextIndex(int n) {
        this.flatContextIndex = n;
    }
}

