/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.encog.engine.util.EngineArray;
import org.encog.engine.util.ErrorCalculation;
import org.encog.mathutil.randomize.NguyenWidrowRandomizer;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.networks.ContextClearable;
import org.encog.neural.networks.Network;
import org.encog.neural.networks.NeuralOutputHolder;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.logic.NeuralLogic;
import org.encog.neural.networks.logic.SimpleRecurrentLogic;
import org.encog.neural.networks.structure.FlatUpdateNeeded;
import org.encog.neural.networks.structure.NetworkCODEC;
import org.encog.neural.networks.structure.NeuralStructure;
import org.encog.neural.networks.synapse.Synapse;
import org.encog.neural.networks.synapse.SynapseType;
import org.encog.persist.BasicPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.BasicNetworkPersistor;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;
import org.encog.util.obj.ObjectCloner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicNetwork
extends BasicPersistedObject
implements Serializable,
Network,
ContextClearable {
    public static final String TAG_INPUT = "INPUT";
    public static final String TAG_OUTPUT = "OUTPUT";
    public static final String TAG_LIMIT = "CONNECTION_LIMIT";
    public static final String DEFAULT_CONNECTION_LIMIT = "0.0000000001";
    private static final long serialVersionUID = -136440631687066461L;
    private static final transient Logger LOGGER = LoggerFactory.getLogger(BasicNetwork.class);
    private final NeuralStructure structure;
    private NeuralLogic logic;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<String, Layer> layerTags = new HashMap<String, Layer>();

    public static int determineWinner(NeuralData neuralData) {
        int n = 0;
        double d = Double.MIN_VALUE;
        for (int i = 0; i < neuralData.size(); ++i) {
            if (!(neuralData.getData(i) > d)) continue;
            d = neuralData.getData(i);
            n = i;
        }
        return n;
    }

    public BasicNetwork() {
        this.structure = new NeuralStructure(this);
        this.logic = new SimpleRecurrentLogic();
    }

    public BasicNetwork(NeuralLogic neuralLogic) {
        this.structure = new NeuralStructure(this);
        this.logic = neuralLogic;
    }

    @Override
    public void addLayer(Layer layer) {
        layer.setNetwork(this);
        this.structure.assignID(layer);
        this.addLayer(layer, SynapseType.Weighted);
    }

    @Override
    public void addLayer(Layer layer, SynapseType synapseType) {
        if (this.layerTags.size() == 0) {
            this.tagLayer(TAG_INPUT, layer);
            this.tagLayer(TAG_OUTPUT, layer);
        } else {
            Layer layer2 = this.getLayer(TAG_OUTPUT);
            layer2.addNext(layer, synapseType);
            this.tagLayer(TAG_OUTPUT, layer);
        }
    }

    @Override
    public double calculateError(NeuralDataSet neuralDataSet) {
        ErrorCalculation errorCalculation = new ErrorCalculation();
        this.clearContext();
        for (NeuralDataPair neuralDataPair : neuralDataSet) {
            NeuralData neuralData = this.compute(neuralDataPair.getInput());
            errorCalculation.updateError(neuralData.getData(), neuralDataPair.getIdeal().getData());
        }
        return errorCalculation.calculate();
    }

    @Override
    public int calculateNeuronCount() {
        int n = 0;
        for (Layer layer : this.structure.getLayers()) {
            n += layer.getNeuronCount();
        }
        return n;
    }

    @Override
    public void clearContext() {
        for (Layer encogPersistedObject : this.structure.getLayers()) {
            if (!(encogPersistedObject instanceof ContextClearable)) continue;
            ((ContextClearable)((Object)encogPersistedObject)).clearContext();
        }
        for (Synapse synapse : this.structure.getSynapses()) {
            if (!(synapse instanceof ContextClearable)) continue;
            ((ContextClearable)((Object)synapse)).clearContext();
        }
        this.structure.updateFlatNetwork();
        if (this.structure.getFlat() != null) {
            this.structure.getFlat().clearContext();
        }
    }

    public void clearLayerTags() {
        this.layerTags.clear();
    }

    @Override
    public Object clone() {
        BasicNetwork basicNetwork = (BasicNetwork)ObjectCloner.deepCopy(this);
        basicNetwork.getStructure().finalizeStructure();
        return basicNetwork;
    }

    @Override
    public void compute(double[] dArray, double[] dArray2) {
        BasicNeuralData basicNeuralData = new BasicNeuralData(dArray);
        NeuralData neuralData = this.compute(basicNeuralData);
        EngineArray.arrayCopy(neuralData.getData(), dArray2);
    }

    @Override
    public NeuralData compute(NeuralData neuralData) {
        try {
            return this.logic.compute(neuralData, null);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NeuralNetworkError("Index exception: there was likely a mismatch between layer sizes, or the size of the input presented to the network.", arrayIndexOutOfBoundsException);
        }
    }

    @Override
    public NeuralData compute(NeuralData neuralData, NeuralOutputHolder neuralOutputHolder) {
        return this.logic.compute(neuralData, neuralOutputHolder);
    }

    @Override
    public Persistor createPersistor() {
        return new BasicNetworkPersistor();
    }

    public String dumpWeights() {
        this.structure.updateFlatNetwork();
        StringBuilder stringBuilder = new StringBuilder();
        NumberList.toList(CSVFormat.EG_FORMAT, stringBuilder, this.structure.getFlat().getWeights());
        return stringBuilder.toString();
    }

    public void enableConnection(Synapse synapse, int n, int n2, boolean bl) {
        if (synapse.getMatrix() == null) {
            throw new NeuralNetworkError("Can't enable/disable connection on a synapse that does not have a weight matrix.");
        }
        double d = synapse.getMatrix().get(n, n2);
        if (bl) {
            if (!this.structure.isConnectionLimited()) {
                return;
            }
            if (Math.abs(d) < this.structure.getConnectionLimit()) {
                synapse.getMatrix().set(n, n2, RangeRandomizer.randomize(-1.0, 1.0));
            }
        } else {
            if (!this.structure.isConnectionLimited()) {
                this.properties.put(TAG_LIMIT, DEFAULT_CONNECTION_LIMIT);
                this.structure.finalizeStructure();
            }
            synapse.getMatrix().set(n, n2, 0.0);
        }
        this.structure.setFlatUpdate(FlatUpdateNeeded.Flatten);
    }

    @Override
    public boolean equals(BasicNetwork basicNetwork) {
        return this.equals(basicNetwork, 10);
    }

    @Override
    public boolean equals(BasicNetwork basicNetwork, int n) {
        return NetworkCODEC.equals(this, basicNetwork, n);
    }

    @Override
    public int getInputCount() {
        Layer layer = this.layerTags.get(TAG_INPUT);
        if (layer == null) {
            return 0;
        }
        return layer.getNeuronCount();
    }

    public Layer getLayer(String string) {
        return this.layerTags.get(string);
    }

    public Map<String, Layer> getLayerTags() {
        return this.layerTags;
    }

    public NeuralLogic getLogic() {
        return this.logic;
    }

    @Override
    public int getOutputCount() {
        Layer layer = this.layerTags.get(TAG_OUTPUT);
        if (layer == null) {
            return 0;
        }
        return layer.getNeuronCount();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public double getPropertyDouble(String string) {
        return Double.parseDouble(this.properties.get(string));
    }

    public long getPropertyLong(String string) {
        return Long.parseLong(this.properties.get(string));
    }

    public String getPropertyString(String string) {
        return this.properties.get(string);
    }

    @Override
    public NeuralStructure getStructure() {
        return this.structure;
    }

    public Collection<String> getTags(Layer layer) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, Layer> entry : this.layerTags.entrySet()) {
            if (entry.getValue() != layer) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    @Override
    public int getWeightMatrixSize() {
        int n = 0;
        for (Synapse synapse : this.structure.getSynapses()) {
            n += synapse.getMatrixSize();
        }
        return n;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isConnected(Synapse synapse, int n, int n2) {
        if (!this.structure.isConnectionLimited()) {
            return true;
        }
        double d = synapse.getMatrix().get(n, n2);
        return Math.abs(d) > this.structure.getConnectionLimit();
    }

    @Override
    public void reset() {
        Layer layer = this.getLayer(TAG_INPUT);
        Layer layer2 = this.getLayer(TAG_OUTPUT);
        if (this.structure.getLayers().size() < 3 || layer == null || layer2 == null) {
            new RangeRandomizer(-1.0, 1.0).randomize(this);
        } else {
            new NguyenWidrowRandomizer(-1.0, 1.0).randomize(this);
        }
        this.structure.setFlatUpdate(FlatUpdateNeeded.Flatten);
        this.structure.flattenWeights();
    }

    public void setBiasActivation(double d) {
        for (Layer layer : this.structure.getLayers()) {
            if (!layer.hasBias()) continue;
            layer.setBiasActivation(d);
        }
    }

    public void setLogic(NeuralLogic neuralLogic) {
        this.logic = neuralLogic;
    }

    public void setProperty(String string, double d) {
        this.properties.put(string, "" + d);
    }

    public void setProperty(String string, long l) {
        this.properties.put(string, "" + l);
    }

    public void setProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public void tagLayer(String string, Layer layer) {
        layer.setNetwork(this);
        this.layerTags.put(string, layer);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[BasicNetwork: Layers=");
        int n = this.structure.getLayers().size();
        stringBuilder.append(n);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public int winner(NeuralData neuralData) {
        NeuralData neuralData2 = this.compute(neuralData);
        return BasicNetwork.determineWinner(neuralData2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.structure.updateFlatNetwork();
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.structure.finalizeStructure();
    }
}

