/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataError;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.parse.tags.read.ReadXML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLNeuralDataSet
implements NeuralDataSet {
    private static final long serialVersionUID = -5960796361565902008L;
    public static final String ADD_NOT_SUPPORTED = "Adds are not supported with this dataset, it is read only.";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String filename;
    private final String pairXML;
    private final String inputXML;
    private final String idealXML;
    private final String valueXML;
    private final int inputSize;
    private final int idealSize;
    private final List<XMLNeuralIterator> iterators = new ArrayList<XMLNeuralIterator>();

    public XMLNeuralDataSet(String string, int n, int n2, String string2, String string3, String string4, String string5) {
        this.filename = string;
        this.pairXML = string2;
        this.inputXML = string3;
        this.idealXML = string4;
        this.valueXML = string5;
        this.idealSize = n2;
        this.inputSize = n;
    }

    @Override
    public void add(NeuralData neuralData) {
        throw new NeuralDataError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void add(NeuralData neuralData, NeuralData neuralData2) {
        throw new NeuralDataError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void add(NeuralDataPair neuralDataPair) {
        throw new NeuralDataError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void close() {
        for (int i = 0; i < this.iterators.size(); ++i) {
            XMLNeuralIterator xMLNeuralIterator = this.iterators.get(i);
            xMLNeuralIterator.remove();
        }
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public int getIdealSize() {
        return this.idealSize;
    }

    public String getIdealXML() {
        return this.idealXML;
    }

    @Override
    public int getInputSize() {
        return this.inputSize;
    }

    public String getInputXML() {
        return this.inputXML;
    }

    public String getPairXML() {
        return this.pairXML;
    }

    public String getValueXML() {
        return this.valueXML;
    }

    @Override
    public Iterator<NeuralDataPair> iterator() {
        XMLNeuralIterator xMLNeuralIterator = new XMLNeuralIterator();
        this.iterators.add(xMLNeuralIterator);
        return xMLNeuralIterator;
    }

    @Override
    public boolean isSupervised() {
        return this.idealSize > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class XMLNeuralIterator
    implements Iterator<NeuralDataPair> {
        private InputStream file;
        private ReadXML reader;
        private NeuralDataPair nextPair;

        public XMLNeuralIterator() {
            try {
                this.file = new FileInputStream(XMLNeuralDataSet.this.getFilename());
                this.reader = new ReadXML(this.file);
            }
            catch (IOException iOException) {
                if (XMLNeuralDataSet.this.logger.isErrorEnabled()) {
                    XMLNeuralDataSet.this.logger.error("Exception", (Throwable)iOException);
                }
                throw new NeuralNetworkError(iOException);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.nextPair != null) {
                return true;
            }
            return this.obtainNext();
        }

        private void invalidError() {
            if (XMLNeuralDataSet.this.logger.isErrorEnabled()) {
                XMLNeuralDataSet.this.logger.error("Could not parse XML, inconsistant tag structure.");
            }
            throw new NeuralNetworkError("Could not parse XML, inconsistant tag structure.");
        }

        @Override
        public NeuralDataPair next() {
            NeuralDataPair neuralDataPair = this.nextPair;
            if (neuralDataPair == null) {
                if (!this.obtainNext()) {
                    return null;
                }
                neuralDataPair = this.nextPair;
            }
            this.nextPair = null;
            return neuralDataPair;
        }

        private boolean obtainNext() {
            String string;
            int n;
            if (!this.reader.findTag(XMLNeuralDataSet.this.getPairXML(), true)) {
                return false;
            }
            BasicNeuralData basicNeuralData = new BasicNeuralData(XMLNeuralDataSet.this.inputSize);
            BasicNeuralData basicNeuralData2 = new BasicNeuralData(XMLNeuralDataSet.this.idealSize);
            if (!this.reader.findTag(XMLNeuralDataSet.this.getInputXML(), true)) {
                this.invalidError();
            }
            for (n = 0; n < XMLNeuralDataSet.this.inputSize; ++n) {
                if (!this.reader.findTag(XMLNeuralDataSet.this.getValueXML(), true)) {
                    this.invalidError();
                }
                string = this.reader.readTextToTag();
                basicNeuralData.setData(n, Double.parseDouble(string));
            }
            if (XMLNeuralDataSet.this.idealSize > 0) {
                if (!this.reader.findTag(XMLNeuralDataSet.this.getIdealXML(), true)) {
                    this.invalidError();
                }
                for (n = 0; n < XMLNeuralDataSet.this.idealSize; ++n) {
                    if (!this.reader.findTag(XMLNeuralDataSet.this.getValueXML(), true)) {
                        this.invalidError();
                    }
                    string = this.reader.readTextToTag();
                    basicNeuralData2.setData(n, Double.parseDouble(string));
                }
            }
            this.nextPair = basicNeuralData2 != null ? new BasicNeuralDataPair(basicNeuralData, basicNeuralData2) : new BasicNeuralDataPair(basicNeuralData);
            return true;
        }

        @Override
        public void remove() {
            try {
                this.file.close();
                XMLNeuralDataSet.this.iterators.remove(this);
            }
            catch (IOException iOException) {
                if (XMLNeuralDataSet.this.logger.isErrorEnabled()) {
                    XMLNeuralDataSet.this.logger.error("Error", (Throwable)iOException);
                }
                throw new NeuralNetworkError(iOException);
            }
        }
    }
}

