/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.market.loader;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.encog.neural.data.market.MarketDataType;
import org.encog.neural.data.market.TickerSymbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadedMarketData
implements Comparable<LoadedMarketData> {
    public final int INDEX_DOUBLE_HIGH = 0;
    public final int INDEX_DOUBLE_LOW = 0;
    public final int INDEX_DOUBLE_OPEN = 0;
    public final int INDEX_DOUBLE_CLOSE = 0;
    private final Date when;
    private final TickerSymbol ticker;
    private final Map<MarketDataType, Double> data;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public LoadedMarketData(Date date, TickerSymbol tickerSymbol) {
        this.when = date;
        this.ticker = tickerSymbol;
        this.data = new HashMap<MarketDataType, Double>();
    }

    @Override
    public int compareTo(LoadedMarketData loadedMarketData) {
        return this.getWhen().compareTo(loadedMarketData.getWhen());
    }

    public double getData(MarketDataType marketDataType) {
        return this.data.get((Object)marketDataType);
    }

    public TickerSymbol getTicker() {
        return this.ticker;
    }

    public Date getWhen() {
        return this.when;
    }

    public void setData(MarketDataType marketDataType, double d) {
        this.data.put(marketDataType, d);
    }
}

