/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.folded;

import java.util.Iterator;
import org.encog.engine.data.EngineData;
import org.encog.engine.data.EngineIndexableSet;
import org.encog.neural.data.Indexable;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.folded.FoldedIterator;
import org.encog.neural.networks.training.TrainingError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoldedDataSet
implements Indexable {
    public static final String ADD_NOT_SUPPORTED = "Direct adds to the folded dataset are not supported.";
    private final Indexable underlying;
    private int currentFold;
    private int numFolds;
    private int foldSize;
    private int lastFoldSize;
    private int currentFoldOffset;
    private int currentFoldSize;
    private FoldedDataSet owner;

    public FoldedDataSet(Indexable indexable) {
        this.underlying = indexable;
        this.fold(1);
    }

    @Override
    public void add(NeuralData neuralData) {
        throw new TrainingError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void add(NeuralData neuralData, NeuralData neuralData2) {
        throw new TrainingError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void add(NeuralDataPair neuralDataPair) {
        throw new TrainingError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void close() {
        this.underlying.close();
    }

    public void fold(int n) {
        this.numFolds = (int)Math.min((long)n, this.underlying.getRecordCount());
        this.foldSize = (int)(this.underlying.getRecordCount() / (long)this.numFolds);
        this.lastFoldSize = (int)(this.underlying.getRecordCount() - (long)(this.foldSize * this.numFolds));
        this.setCurrentFold(0);
    }

    public int getCurrentFold() {
        if (this.owner != null) {
            return this.owner.getCurrentFold();
        }
        return this.currentFold;
    }

    public int getCurrentFoldOffset() {
        if (this.owner != null) {
            return this.owner.getCurrentFoldOffset();
        }
        return this.currentFoldOffset;
    }

    public int getCurrentFoldSize() {
        if (this.owner != null) {
            return this.owner.getCurrentFoldSize();
        }
        return this.currentFoldSize;
    }

    @Override
    public int getIdealSize() {
        return this.underlying.getIdealSize();
    }

    @Override
    public int getInputSize() {
        return this.underlying.getInputSize();
    }

    public int getNumFolds() {
        return this.numFolds;
    }

    @Override
    public void getRecord(long l, EngineData engineData) {
        this.underlying.getRecord((long)this.getCurrentFoldOffset() + l, engineData);
    }

    @Override
    public long getRecordCount() {
        return this.getCurrentFoldSize();
    }

    public Indexable getUnderlying() {
        return this.underlying;
    }

    @Override
    public boolean isSupervised() {
        return this.underlying.isSupervised();
    }

    public FoldedDataSet getOwner() {
        return this.owner;
    }

    public void setOwner(FoldedDataSet foldedDataSet) {
        this.owner = foldedDataSet;
    }

    @Override
    public Iterator<NeuralDataPair> iterator() {
        return new FoldedIterator(this);
    }

    @Override
    public EngineIndexableSet openAdditional() {
        FoldedDataSet foldedDataSet = new FoldedDataSet((Indexable)this.underlying.openAdditional());
        foldedDataSet.setOwner(this);
        return foldedDataSet;
    }

    public void setCurrentFold(int n) {
        if (this.owner != null) {
            throw new TrainingError("Can't set the fold on a non-top-level set.");
        }
        if (n >= this.numFolds) {
            throw new TrainingError("Can't set the current fold to be greater than the number of folds.");
        }
        this.currentFold = n;
        this.currentFoldOffset = this.foldSize * this.currentFold;
        this.currentFoldSize = this.currentFold == this.numFolds - 1 ? this.lastFoldSize : this.foldSize;
    }
}

