/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.buffer;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.encog.neural.data.buffer.BufferedDataError;

public class EncogEGBFile {
    public static final int DOUBLE_SIZE = 8;
    public static final int HEADER_SIZE = 24;
    private File file;
    private int inputCount;
    private int idealCount;
    private RandomAccessFile raf;
    private FileChannel fc;
    private ByteBuffer headerBuffer;
    private ByteBuffer recordBuffer;
    private int recordCount;
    private int recordSize;
    private int numberOfRecords;

    public EncogEGBFile(File file) {
        this.file = file;
        this.headerBuffer = ByteBuffer.allocate(24);
    }

    public void create(int n, int n2) {
        try {
            this.inputCount = n;
            this.idealCount = n2;
            double[] dArray = new double[n];
            double[] dArray2 = new double[n2];
            this.file.delete();
            this.raf = new RandomAccessFile(this.file, "rw");
            this.fc = this.raf.getChannel();
            this.headerBuffer.clear();
            this.headerBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.headerBuffer.put((byte)69);
            this.headerBuffer.put((byte)78);
            this.headerBuffer.put((byte)67);
            this.headerBuffer.put((byte)79);
            this.headerBuffer.put((byte)71);
            this.headerBuffer.put((byte)45);
            this.headerBuffer.put((byte)48);
            this.headerBuffer.put((byte)48);
            this.headerBuffer.putDouble(dArray.length);
            this.headerBuffer.putDouble(dArray2.length);
            this.numberOfRecords = 0;
            this.recordCount = this.inputCount + this.idealCount;
            this.recordSize = this.recordCount * 8;
            this.recordBuffer = ByteBuffer.allocate(this.recordSize);
            this.headerBuffer.flip();
            this.fc.write(this.headerBuffer);
        }
        catch (IOException iOException) {
            throw new BufferedDataError(iOException);
        }
    }

    public void open() {
        try {
            this.raf = new RandomAccessFile(this.file, "rw");
            this.fc = this.raf.getChannel();
            this.headerBuffer.clear();
            this.headerBuffer.order(ByteOrder.LITTLE_ENDIAN);
            boolean bl = true;
            this.fc.read(this.headerBuffer);
            this.headerBuffer.position(0);
            boolean bl2 = bl ? this.headerBuffer.get() == 69 : (bl = false);
            boolean bl3 = bl ? this.headerBuffer.get() == 78 : (bl = false);
            boolean bl4 = bl ? this.headerBuffer.get() == 67 : (bl = false);
            boolean bl5 = bl ? this.headerBuffer.get() == 79 : (bl = false);
            boolean bl6 = bl ? this.headerBuffer.get() == 71 : (bl = false);
            boolean bl7 = bl ? this.headerBuffer.get() == 45 : (bl = false);
            if (!bl) {
                throw new BufferedDataError("File is not a valid Encog binary file:" + this.file.toString());
            }
            char c = (char)this.headerBuffer.get();
            char c2 = (char)this.headerBuffer.get();
            String string = "" + c + c2;
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    throw new BufferedDataError("File is from a newer version of Encog than is currently in use.");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new BufferedDataError("File has invalid version number.");
            }
            this.inputCount = (int)this.headerBuffer.getDouble();
            this.idealCount = (int)this.headerBuffer.getDouble();
            this.recordCount = this.inputCount + this.idealCount;
            this.recordSize = this.recordCount * 8;
            this.numberOfRecords = (int)((this.file.length() - 24L) / (long)this.recordSize);
            this.recordBuffer = ByteBuffer.allocate(this.recordSize);
        }
        catch (IOException iOException) {
            throw new BufferedDataError(iOException);
        }
    }

    public void close() {
        try {
            if (this.raf != null) {
                this.raf.close();
                this.raf = null;
            }
            if (this.fc != null) {
                this.fc.close();
                this.fc = null;
            }
        }
        catch (IOException iOException) {
            throw new BufferedDataError(iOException);
        }
    }

    private int calculateIndex(int n) {
        return 24 + n * this.recordSize;
    }

    private int calculateIndex(int n, int n2) {
        return 24 + n * this.recordSize + n2 * 8;
    }

    public void setLocation(int n) {
        try {
            this.fc.position(this.calculateIndex(n));
        }
        catch (IOException iOException) {
            throw new BufferedDataError(iOException);
        }
    }

    private void clear() {
        this.recordBuffer.clear();
        this.recordBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void write(int n, int n2, double d) {
        try {
            this.clear();
            this.recordBuffer.putDouble(d);
            this.recordBuffer.flip();
            this.fc.write(this.recordBuffer, this.calculateIndex(n, n2));
        }
        catch (IOException iOException) {
            throw new BufferedDataError(iOException);
        }
    }

    public void write(int n, double[] dArray) {
        try {
            this.clear();
            for (int i = 0; i < dArray.length; ++i) {
                this.recordBuffer.putDouble(dArray[i]);
            }
            this.recordBuffer.flip();
            this.fc.write(this.recordBuffer);
        }
        catch (IOException iOException) {
            throw new BufferedDataError(iOException);
        }
    }

    public void write(double[] dArray) {
        try {
            this.clear();
            for (int i = 0; i < dArray.length; ++i) {
                this.recordBuffer.putDouble(dArray[i]);
            }
            this.recordBuffer.flip();
            this.fc.write(this.recordBuffer);
        }
        catch (IOException iOException) {
            throw new BufferedDataError(iOException);
        }
    }

    public void write(byte by) {
        try {
            this.clear();
            this.recordBuffer.put(by);
            this.recordBuffer.flip();
            this.fc.write(this.recordBuffer);
        }
        catch (IOException iOException) {
            throw new BufferedDataError(iOException);
        }
    }

    public double read(int n, int n2) {
        try {
            this.clear();
            this.recordBuffer.limit(8);
            this.fc.read(this.recordBuffer, this.calculateIndex(n, n2));
            this.recordBuffer.position(0);
            return this.recordBuffer.getDouble(0);
        }
        catch (IOException iOException) {
            throw new BufferedDataError(iOException);
        }
    }

    public void read(int n, double[] dArray) {
        try {
            this.clear();
            this.recordBuffer.limit(8 * dArray.length);
            this.fc.read(this.recordBuffer, this.calculateIndex(n));
            this.recordBuffer.position(0);
            for (int i = 0; i < this.recordCount; ++i) {
                dArray[i] = this.recordBuffer.getDouble();
            }
        }
        catch (IOException iOException) {
            throw new BufferedDataError(iOException);
        }
    }

    public void read(double[] dArray) {
        try {
            this.clear();
            this.recordBuffer.limit(8 * dArray.length);
            this.fc.read(this.recordBuffer);
            this.recordBuffer.position(0);
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.recordBuffer.getDouble();
            }
        }
        catch (IOException iOException) {
            throw new BufferedDataError(iOException);
        }
    }

    public final double read() {
        try {
            this.clear();
            this.recordBuffer.limit(8);
            this.fc.read(this.recordBuffer);
            this.recordBuffer.position(0);
            return this.recordBuffer.getDouble();
        }
        catch (IOException iOException) {
            throw new BufferedDataError(iOException);
        }
    }

    public File getFile() {
        return this.file;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public int getIdealCount() {
        return this.idealCount;
    }

    public RandomAccessFile getRaf() {
        return this.raf;
    }

    public FileChannel getFc() {
        return this.fc;
    }

    public ByteBuffer getHeaderBuffer() {
        return this.headerBuffer;
    }

    public ByteBuffer getRecordBuffer() {
        return this.recordBuffer;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public int getRecordSize() {
        return this.recordSize;
    }

    public int getNumberOfRecords() {
        return this.numberOfRecords;
    }

    public void deleteRow(int n) {
        try {
            for (int i = n; i < this.numberOfRecords - 1; ++i) {
                int n2 = 24 + this.recordSize * i + this.recordSize;
                int n3 = 24 + this.recordSize * i;
                this.clear();
                this.fc.read(this.recordBuffer, n2);
                this.recordBuffer.flip();
                this.fc.write(this.recordBuffer, n3);
            }
            --this.numberOfRecords;
            this.raf.setLength(this.numberOfRecords * this.recordSize + 24);
        }
        catch (IOException iOException) {
            throw new BufferedDataError(iOException);
        }
    }

    public void addRow(int n) {
        try {
            int n2;
            ++this.numberOfRecords;
            this.raf.setLength(this.numberOfRecords * this.recordSize + 24);
            for (n2 = this.numberOfRecords - 1; n2 >= n; --n2) {
                int n3 = 24 + this.recordSize * n2;
                int n4 = 24 + this.recordSize * n2 + this.recordSize;
                this.clear();
                this.fc.read(this.recordBuffer, n3);
                this.recordBuffer.flip();
                this.fc.write(this.recordBuffer, n4);
            }
            this.clear();
            for (n2 = 0; n2 < this.recordCount; ++n2) {
                this.recordBuffer.putDouble(0.0);
            }
            this.recordBuffer.flip();
            this.fc.write(this.recordBuffer, 24 + this.recordSize * n);
        }
        catch (IOException iOException) {
            throw new BufferedDataError(iOException);
        }
    }

    private long checkWrite(ByteBuffer byteBuffer, long l) throws IOException {
        long l2 = l;
        if (!byteBuffer.hasRemaining()) {
            this.fc.position(l2);
            byteBuffer.flip();
            this.fc.write(byteBuffer);
            l2 = this.fc.position();
            byteBuffer.clear();
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        return l2;
    }

    public void deleteCol(int n) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(8192);
            byteBuffer.clear();
            byteBuffer2.clear();
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            long l = 24L;
            long l2 = 24L;
            int n2 = 0;
            this.fc.position(l);
            this.fc.read(byteBuffer);
            l = this.fc.position();
            byteBuffer.rewind();
            boolean bl = false;
            int n3 = 0;
            do {
                if (byteBuffer.hasRemaining()) {
                    double d = byteBuffer.getDouble();
                    if (n2 != n) {
                        l2 = this.checkWrite(byteBuffer2, l2);
                        byteBuffer2.putDouble(d);
                    }
                    if (++n2 < this.recordCount) continue;
                    n2 = 0;
                    if (++n3 < this.numberOfRecords) continue;
                    bl = true;
                    continue;
                }
                byteBuffer.clear();
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this.fc.position(l);
                this.fc.read(byteBuffer);
                l = this.fc.position();
                byteBuffer.rewind();
            } while (!bl);
            if (byteBuffer2.position() > 0) {
                byteBuffer2.flip();
                this.fc.write(byteBuffer2, l2);
            }
            if (n < this.inputCount) {
                --this.inputCount;
                --this.recordCount;
            } else {
                --this.idealCount;
                --this.recordCount;
            }
            this.recordCount = this.inputCount + this.idealCount;
            this.recordSize = this.recordCount * 8;
            this.raf.setLength(this.numberOfRecords * this.recordSize + 24);
        }
        catch (IOException iOException) {
            throw new BufferedDataError(iOException);
        }
    }

    public void addColumn(int n, boolean bl) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(8192);
            byteBuffer.clear();
            byteBuffer2.clear();
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            long l = 24L;
            long l2 = 24L;
            int n2 = 0;
            this.fc.position(l);
            this.fc.read(byteBuffer);
            l = this.fc.position();
            byteBuffer.rewind();
            boolean bl2 = false;
            int n3 = 0;
            do {
                if (byteBuffer.hasRemaining()) {
                    double d = byteBuffer.getDouble();
                    if (n2 == n) {
                        l2 = this.checkWrite(byteBuffer2, l2);
                        byteBuffer2.putDouble(0.0);
                    }
                    l2 = this.checkWrite(byteBuffer2, l2);
                    byteBuffer2.putDouble(d);
                    if (++n2 < this.recordCount) continue;
                    n2 = 0;
                    if (++n3 < this.numberOfRecords) continue;
                    bl2 = true;
                    continue;
                }
                byteBuffer.clear();
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this.fc.position(l);
                this.fc.read(byteBuffer);
                l = this.fc.position();
                byteBuffer.rewind();
            } while (!bl2);
            if (byteBuffer2.position() > 0) {
                byteBuffer2.flip();
                this.fc.write(byteBuffer2, l2);
            }
            if (bl) {
                ++this.inputCount;
                ++this.recordCount;
            } else {
                ++this.idealCount;
                ++this.recordCount;
            }
            this.recordCount = this.inputCount + this.idealCount;
            this.recordSize = this.recordCount * 8;
            this.raf.setLength(this.numberOfRecords * this.recordSize + 24);
        }
        catch (IOException iOException) {
            throw new BufferedDataError(iOException);
        }
    }
}

