/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.basic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.encog.engine.data.EngineData;
import org.encog.neural.data.Indexable;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.persist.EncogCollection;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.BasicNeuralDataSetPersistor;
import org.encog.util.obj.ObjectCloner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicNeuralDataSet
implements EncogPersistedObject,
Serializable,
Indexable {
    private static final long serialVersionUID = -2279722928570071183L;
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private EncogCollection encogCollection;
    private List<NeuralDataPair> data = new ArrayList<NeuralDataPair>();
    private String description;
    private String name;

    public BasicNeuralDataSet() {
    }

    public BasicNeuralDataSet(double[][] dArray, double[][] dArray2) {
        if (dArray2 != null) {
            for (int i = 0; i < dArray.length; ++i) {
                BasicNeuralData basicNeuralData = new BasicNeuralData(dArray[i]);
                BasicNeuralData basicNeuralData2 = new BasicNeuralData(dArray2[i]);
                this.add(basicNeuralData, basicNeuralData2);
            }
        } else {
            for (double[] dArray3 : dArray) {
                BasicNeuralData basicNeuralData = new BasicNeuralData(dArray3);
                this.add(basicNeuralData);
            }
        }
    }

    public BasicNeuralDataSet(List<NeuralDataPair> list) {
        this.data = list;
    }

    @Override
    public void add(NeuralData neuralData) {
        this.data.add(new BasicNeuralDataPair(neuralData));
    }

    @Override
    public void add(NeuralData neuralData, NeuralData neuralData2) {
        BasicNeuralDataPair basicNeuralDataPair = new BasicNeuralDataPair(neuralData, neuralData2);
        this.data.add(basicNeuralDataPair);
    }

    @Override
    public void add(NeuralDataPair neuralDataPair) {
        this.data.add(neuralDataPair);
    }

    public Object clone() {
        return ObjectCloner.deepCopy(this);
    }

    @Override
    public void close() {
    }

    @Override
    public Persistor createPersistor() {
        return new BasicNeuralDataSetPersistor();
    }

    public List<NeuralDataPair> getData() {
        return this.data;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getIdealSize() {
        if (this.data.isEmpty()) {
            return 0;
        }
        NeuralDataPair neuralDataPair = this.data.get(0);
        if (neuralDataPair.getIdeal() == null) {
            return 0;
        }
        return neuralDataPair.getIdeal().size();
    }

    @Override
    public int getInputSize() {
        if (this.data.isEmpty()) {
            return 0;
        }
        NeuralDataPair neuralDataPair = this.data.get(0);
        return neuralDataPair.getInput().size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void getRecord(long l, EngineData engineData) {
        NeuralDataPair neuralDataPair = this.data.get((int)l);
        engineData.setInputArray(neuralDataPair.getInputArray());
        if (engineData.getIdealArray() != null) {
            engineData.setIdealArray(neuralDataPair.getIdealArray());
        }
    }

    @Override
    public long getRecordCount() {
        return this.data.size();
    }

    @Override
    public boolean isSupervised() {
        if (this.data.size() == 0) {
            return false;
        }
        return this.data.get(0).isSupervised();
    }

    @Override
    public Iterator<NeuralDataPair> iterator() {
        BasicNeuralIterator basicNeuralIterator = new BasicNeuralIterator();
        return basicNeuralIterator;
    }

    @Override
    public Indexable openAdditional() {
        return new BasicNeuralDataSet(this.data);
    }

    public void setData(List<NeuralDataPair> list) {
        this.data = list;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public EncogCollection getCollection() {
        return this.encogCollection;
    }

    @Override
    public void setCollection(EncogCollection encogCollection) {
        this.encogCollection = encogCollection;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BasicNeuralIterator
    implements Iterator<NeuralDataPair> {
        private int currentIndex = 0;

        @Override
        public boolean hasNext() {
            return this.currentIndex < BasicNeuralDataSet.this.data.size();
        }

        @Override
        public NeuralDataPair next() {
            if (!this.hasNext()) {
                return null;
            }
            return (NeuralDataPair)BasicNeuralDataSet.this.data.get(this.currentIndex++);
        }

        @Override
        public void remove() {
            if (BasicNeuralDataSet.this.logger.isErrorEnabled()) {
                BasicNeuralDataSet.this.logger.error("Called remove, unsupported operation.");
            }
            throw new UnsupportedOperationException();
        }
    }
}

