/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize;

import org.encog.EncogError;
import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.randomize.BasicRandomizer;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.synapse.Synapse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FanInRandomizer
extends BasicRandomizer {
    static final String ERROR = "To use FanInRandomizer you must present a Matrix or 2D array type value.";
    private static final double DEFAULT_BOUNDARY = 2.4;
    private final double lowerBound;
    private final double upperBound;
    private final boolean sqrt;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public FanInRandomizer() {
        this(-2.4, 2.4, false);
    }

    public FanInRandomizer(double d, boolean bl) {
        this(-d, d, bl);
    }

    public FanInRandomizer(double d, double d2, boolean bl) {
        this.lowerBound = d;
        this.upperBound = d2;
        this.sqrt = bl;
    }

    private double calculateValue(int n) {
        double d = this.sqrt ? Math.sqrt(n) : (double)n;
        return this.lowerBound / d + this.nextDouble() * ((this.upperBound - this.lowerBound) / d);
    }

    private void causeError() {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(ERROR);
        }
        throw new EncogError(ERROR);
    }

    public void randomize(BasicNetwork basicNetwork, Synapse synapse) {
        if (synapse.getMatrix() != null) {
            boolean bl = basicNetwork.getStructure().isConnectionLimited();
            double[][] dArray = synapse.getMatrix().getData();
            for (int i = 0; i < synapse.getMatrix().getRows(); ++i) {
                for (int j = 0; j < synapse.getMatrix().getCols(); ++j) {
                    if (bl && !basicNetwork.isConnected(synapse, i, j)) continue;
                    dArray[i][j] = this.calculateValue(synapse.getMatrix().getRows());
                }
            }
        }
    }

    public double randomize(double d) {
        this.causeError();
        return 0.0;
    }

    public void randomize(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.calculateValue(1);
        }
    }

    public void randomize(Double[] doubleArray) {
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = this.calculateValue(1);
        }
    }

    public void randomize(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                dArray[i][j] = this.calculateValue(dArray.length);
            }
        }
    }

    public void randomize(Double[][] doubleArray) {
        for (int i = 0; i < doubleArray.length; ++i) {
            for (int j = 0; j < doubleArray[0].length; ++j) {
                doubleArray[i][j] = this.calculateValue(doubleArray.length);
            }
        }
    }

    public void randomize(Matrix matrix) {
        for (int i = 0; i < matrix.getRows(); ++i) {
            for (int j = 0; j < matrix.getCols(); ++j) {
                matrix.set(i, j, this.calculateValue(matrix.getRows()));
            }
        }
    }
}

