/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize;

import java.util.Random;
import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.randomize.Randomizer;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.structure.FlatUpdateNeeded;
import org.encog.neural.networks.synapse.Synapse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicRandomizer
implements Randomizer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Random random = new Random(System.nanoTime());

    public void randomize(BasicNetwork basicNetwork) {
        basicNetwork.getStructure().updateFlatNetwork();
        for (Synapse encogPersistedObject : basicNetwork.getStructure().getSynapses()) {
            if (encogPersistedObject.getMatrix() == null) continue;
            this.randomize(basicNetwork, encogPersistedObject);
        }
        for (Layer layer : basicNetwork.getStructure().getLayers()) {
            if (!layer.hasBias()) continue;
            this.randomize(layer.getBiasWeights());
        }
        basicNetwork.getStructure().setFlatUpdate(FlatUpdateNeeded.Flatten);
        basicNetwork.getStructure().flattenWeights();
    }

    public void randomize(BasicNetwork basicNetwork, Synapse synapse) {
        if (synapse.getMatrix() != null) {
            boolean bl = basicNetwork.getStructure().isConnectionLimited();
            double[][] dArray = synapse.getMatrix().getData();
            for (int i = 0; i < synapse.getMatrix().getRows(); ++i) {
                for (int j = 0; j < synapse.getMatrix().getCols(); ++j) {
                    if (bl && !basicNetwork.isConnected(synapse, i, j)) continue;
                    dArray[i][j] = this.randomize(dArray[i][j]);
                }
            }
        }
    }

    public void randomize(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.randomize(dArray[i]);
        }
    }

    public void randomize(Double[] doubleArray) {
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = this.randomize(doubleArray[i]);
        }
    }

    public void randomize(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                dArray[i][j] = this.randomize(dArray[i][j]);
            }
        }
    }

    public void randomize(Double[][] doubleArray) {
        for (int i = 0; i < doubleArray.length; ++i) {
            for (int j = 0; j < doubleArray[0].length; ++j) {
                doubleArray[i][j] = this.randomize(doubleArray[i][j]);
            }
        }
    }

    public void randomize(Matrix matrix) {
        double[][] dArray = matrix.getData();
        for (int i = 0; i < matrix.getRows(); ++i) {
            for (int j = 0; j < matrix.getCols(); ++j) {
                dArray[i][j] = this.randomize(dArray[i][j]);
            }
        }
    }

    public Random getRandom() {
        return this.random;
    }

    public double nextDouble() {
        return this.random.nextDouble();
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public double nextDouble(double d, double d2) {
        double d3 = d2 - d;
        return d3 * this.random.nextDouble() + d;
    }
}

