/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.matrices.decomposition;

import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.matrices.MatrixError;

public class LUDecomposition {
    private double[][] LU;
    private int m;
    private int n;
    private int pivsign;
    private int[] piv;

    public LUDecomposition(Matrix matrix) {
        this.LU = matrix.getArrayCopy();
        this.m = matrix.getRows();
        this.n = matrix.getCols();
        this.piv = new int[this.m];
        for (int i = 0; i < this.m; ++i) {
            this.piv[i] = i;
        }
        this.pivsign = 1;
        double[] dArray = new double[this.m];
        for (int i = 0; i < this.n; ++i) {
            double d;
            int n;
            int n2;
            for (n2 = 0; n2 < this.m; ++n2) {
                dArray[n2] = this.LU[n2][i];
            }
            n2 = 0;
            while (n2 < this.m) {
                double[] dArray2 = this.LU[n2];
                n = Math.min(n2, i);
                d = 0.0;
                for (int j = 0; j < n; ++j) {
                    d += dArray2[j] * dArray[j];
                }
                int n3 = n2++;
                double d2 = dArray[n3] - d;
                dArray[n3] = d2;
                dArray2[i] = d2;
            }
            n2 = i;
            for (n = i + 1; n < this.m; ++n) {
                if (!(Math.abs(dArray[n]) > Math.abs(dArray[n2]))) continue;
                n2 = n;
            }
            if (n2 != i) {
                for (n = 0; n < this.n; ++n) {
                    d = this.LU[n2][n];
                    this.LU[n2][n] = this.LU[i][n];
                    this.LU[i][n] = d;
                }
                n = this.piv[n2];
                this.piv[n2] = this.piv[i];
                this.piv[i] = n;
                this.pivsign = -this.pivsign;
            }
            if (!(i < this.m & this.LU[i][i] != 0.0)) continue;
            for (n = i + 1; n < this.m; ++n) {
                double[] dArray3 = this.LU[n];
                int n4 = i;
                dArray3[n4] = dArray3[n4] / this.LU[i][i];
            }
        }
    }

    public boolean isNonsingular() {
        for (int i = 0; i < this.n; ++i) {
            if (this.LU[i][i] != 0.0) continue;
            return false;
        }
        return true;
    }

    public Matrix getL() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getData();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = i > j ? this.LU[i][j] : (i == j ? 1.0 : 0.0);
            }
        }
        return matrix;
    }

    public Matrix getU() {
        Matrix matrix = new Matrix(this.n, this.n);
        double[][] dArray = matrix.getData();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = i <= j ? this.LU[i][j] : 0.0;
            }
        }
        return matrix;
    }

    public int[] getPivot() {
        int[] nArray = new int[this.m];
        for (int i = 0; i < this.m; ++i) {
            nArray[i] = this.piv[i];
        }
        return nArray;
    }

    public double[] getDoublePivot() {
        double[] dArray = new double[this.m];
        for (int i = 0; i < this.m; ++i) {
            dArray[i] = this.piv[i];
        }
        return dArray;
    }

    public double det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.pivsign;
        for (int i = 0; i < this.n; ++i) {
            d *= this.LU[i][i];
        }
        return d;
    }

    public Matrix solve(Matrix matrix) {
        int n;
        int n2;
        int n3;
        if (matrix.getRows() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int n4 = matrix.getCols();
        Matrix matrix2 = matrix.getMatrix(this.piv, 0, n4 - 1);
        double[][] dArray = matrix2.getData();
        for (n3 = 0; n3 < this.n; ++n3) {
            for (n2 = n3 + 1; n2 < this.n; ++n2) {
                for (n = 0; n < n4; ++n) {
                    double[] dArray2 = dArray[n2];
                    int n5 = n;
                    dArray2[n5] = dArray2[n5] - dArray[n3][n] * this.LU[n2][n3];
                }
            }
        }
        for (n3 = this.n - 1; n3 >= 0; --n3) {
            n2 = 0;
            while (n2 < n4) {
                double[] dArray3 = dArray[n3];
                int n6 = n2++;
                dArray3[n6] = dArray3[n6] / this.LU[n3][n3];
            }
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n4; ++n) {
                    double[] dArray4 = dArray[n2];
                    int n7 = n;
                    dArray4[n7] = dArray4[n7] - dArray[n3][n] * this.LU[n2][n3];
                }
            }
        }
        return matrix2;
    }

    public double[] Solve(double[] dArray) {
        int n;
        int n2;
        int n3;
        if (dArray == null) {
            throw new MatrixError("value");
        }
        if (dArray.length != this.LU.length) {
            throw new MatrixError("Invalid matrix dimensions.");
        }
        if (!this.isNonsingular()) {
            throw new MatrixError("Matrix is singular");
        }
        int n4 = dArray.length;
        double[] dArray2 = new double[n4];
        for (n3 = 0; n3 < dArray2.length; ++n3) {
            dArray2[n3] = dArray[this.piv[n3]];
        }
        n3 = this.LU[0].length;
        int n5 = this.LU[0].length;
        double[][] dArray3 = this.LU;
        double[] dArray4 = new double[n4];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray4[n2] = dArray2[n2];
            for (n = 0; n < n2; ++n) {
                int n6 = n2;
                dArray4[n6] = dArray4[n6] - dArray3[n2][n] * dArray4[n];
            }
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            for (n = n5 - 1; n > n2; --n) {
                int n7 = n2;
                dArray4[n7] = dArray4[n7] - dArray3[n2][n] * dArray4[n];
            }
            int n8 = n2;
            dArray4[n8] = dArray4[n8] / dArray3[n2][n2];
        }
        return dArray4;
    }

    public double[][] inverse() {
        int n;
        int n2;
        int n3;
        if (!this.isNonsingular()) {
            throw new MatrixError("Matrix is singular");
        }
        int n4 = this.LU.length;
        int n5 = this.LU[0].length;
        int n6 = n4;
        double[][] dArray = this.LU;
        double[][] dArray2 = new double[n4][n5];
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = this.piv[n3];
            dArray2[n3][n2] = 1.0;
        }
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = n3 + 1; n2 < n5; ++n2) {
                for (n = 0; n < n6; ++n) {
                    double[] dArray3 = dArray2[n2];
                    int n7 = n;
                    dArray3[n7] = dArray3[n7] - dArray2[n3][n] * dArray[n2][n3];
                }
            }
        }
        for (n3 = n5 - 1; n3 >= 0; --n3) {
            n2 = 0;
            while (n2 < n6) {
                double[] dArray4 = dArray2[n3];
                int n8 = n2++;
                dArray4[n8] = dArray4[n8] / dArray[n3][n3];
            }
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n6; ++n) {
                    double[] dArray5 = dArray2[n2];
                    int n9 = n;
                    dArray5[n9] = dArray5[n9] - dArray2[n3][n] * dArray[n2][n3];
                }
            }
        }
        return dArray2;
    }
}

