/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.util;

import java.text.NumberFormat;

public final class Format {
    public static final int SECONDS_INA_MINUTE = 60;
    public static final int SECONDS_INA_HOUR = 3600;
    public static final int SECONDS_INA_DAY = 86400;
    public static final long MEMORY_K = 1024L;
    public static final long MEMORY_MEG = 0x100000L;
    public static final long MEMORY_GIG = 0x40000000L;
    public static final long MEMORY_TERA = 0x10000000000L;

    public static String formatDouble(double d, int n) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(n);
        return numberFormat.format(d);
    }

    public static String formatInteger(int n) {
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        return numberFormat.format(n);
    }

    public static String formatMemory(long l) {
        if (l < 1024L) {
            return l + " bytes";
        }
        if (l < 0x100000L) {
            return Format.formatDouble((double)l / 1024.0, 2) + " KB";
        }
        if (l < 0x40000000L) {
            return Format.formatDouble((double)l / 1048576.0, 2) + " MB";
        }
        if (l < 0x10000000000L) {
            return Format.formatDouble((double)l / 1.073741824E9, 2) + " GB";
        }
        return Format.formatDouble((double)l / 1.099511627776E12, 2) + " TB";
    }

    public static String formatPercent(double d) {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMinimumFractionDigits(6);
        return numberFormat.format(d);
    }

    public static String formatPercentWhole(double d) {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        return numberFormat.format(d);
    }

    public static String formatTimeSpan(int n) {
        int n2 = n;
        int n3 = n / 86400;
        int n4 = (n2 -= n3 * 86400) / 3600;
        int n5 = (n2 -= n4 * 3600) / 60;
        n2 -= n5 * 60;
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setMinimumIntegerDigits(2);
        numberFormat.setMaximumIntegerDigits(2);
        StringBuilder stringBuilder = new StringBuilder();
        if (n3 > 0) {
            stringBuilder.append(n3);
            if (n3 > 1) {
                stringBuilder.append(" days ");
            } else {
                stringBuilder.append(" day ");
            }
        }
        stringBuilder.append(numberFormat.format(n4));
        stringBuilder.append(':');
        stringBuilder.append(numberFormat.format(n5));
        stringBuilder.append(':');
        stringBuilder.append(numberFormat.format(n2));
        return stringBuilder.toString();
    }

    private Format() {
    }
}

