/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.util.BoundMath;

public class ActivationSigmoid
implements ActivationFunction {
    private static final long serialVersionUID = 5622349801036468572L;
    private double[] params = new double[0];

    public ActivationFunction clone() {
        return new ActivationSigmoid();
    }

    public boolean hasDerivative() {
        return true;
    }

    public void activationFunction(double[] dArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            dArray[i] = 1.0 / (1.0 + BoundMath.exp(-1.0 * dArray[i]));
        }
    }

    public double derivativeFunction(double d) {
        return d * (1.0 - d);
    }

    public String[] getParamNames() {
        String[] stringArray = new String[]{};
        return stringArray;
    }

    public double[] getParams() {
        return this.params;
    }

    public void setParam(int n, double d) {
        this.params[n] = d;
    }

    public String getOpenCLExpression(boolean bl) {
        if (bl) {
            return "(x * (1.0f - x))";
        }
        return "(1.0f / (1.0f + exp(-1 * x)))";
    }
}

