/*
 * Decompiled with CFR 0.152.
 */
package org.encog.cloud;

import java.util.HashMap;
import org.encog.cloud.CloudRequest;
import org.encog.cloud.CloudTask;
import org.encog.cloud.EncogCloudError;

public class EncogCloud {
    public static final String DEFAULT_SERVER = "http://cloud.encog.com/";
    private String session;
    private String server;

    public EncogCloud() {
        this(DEFAULT_SERVER);
    }

    public EncogCloud(String string) {
        this.server = string;
        if (!this.server.endsWith("/")) {
            this.server = this.server + '/';
        }
    }

    public CloudTask beginTask(String string) {
        CloudTask cloudTask = new CloudTask(this);
        cloudTask.init(string);
        return cloudTask;
    }

    public void connect(String string, String string2) {
        CloudRequest cloudRequest = new CloudRequest();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("uid", string);
        hashMap.put("pwd", string2);
        cloudRequest.performURLPOST(false, this.constructService("login"), hashMap);
        if (!"success".equals(cloudRequest.getStatus())) {
            throw new EncogCloudError(cloudRequest.getMessage());
        }
        this.session = cloudRequest.getSession();
    }

    public String constructService(String string) {
        return this.server + string;
    }

    public String getSession() {
        return this.session;
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public void logout() {
        CloudRequest cloudRequest = new CloudRequest();
        cloudRequest.performURLGET(false, this.session + "logout");
        this.session = null;
    }

    public void validateSession(boolean bl) {
        int n = bl ? 1 : 5;
        for (int i = 0; i < n; ++i) {
            CloudRequest cloudRequest = new CloudRequest();
            cloudRequest.performURLGET(false, this.session);
            if (!"success".equals(cloudRequest.getStatus())) continue;
            return;
        }
        if (bl) {
            throw new EncogCloudError("Connection lost");
        }
    }
}

