/*
 * Decompiled with CFR 0.152.
 */
package org.encog.bot.rss;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.encog.bot.BotError;
import org.encog.bot.rss.RSSItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSS {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final List<RSSItem> items = new ArrayList<RSSItem>();

    public static String getXMLText(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 3) continue;
            return node2.getNodeValue();
        }
        return null;
    }

    public static Date parseDate(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z");
            Date date = simpleDateFormat.parse(string);
            return date;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<RSSItem> getItems() {
        return this.items;
    }

    public void load(URL uRL) {
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Loading RSS from:" + uRL);
            }
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Win64; x64; Trident/4.0)");
            InputStream inputStream = uRLConnection.getInputStream();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Document document = documentBuilderFactory.newDocumentBuilder().parse(inputStream);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String string = node.getNodeName();
                if (string.equalsIgnoreCase("channel")) {
                    this.loadChannel(node);
                    continue;
                }
                if (!string.equalsIgnoreCase("item")) continue;
                this.loadItem(node);
            }
        }
        catch (IOException iOException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception", (Throwable)iOException);
            }
            throw new BotError(iOException);
        }
        catch (SAXException sAXException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception", (Throwable)sAXException);
            }
            throw new BotError(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception", (Throwable)parserConfigurationException);
            }
            throw new BotError(parserConfigurationException);
        }
    }

    private void loadChannel(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equalsIgnoreCase("item")) {
                this.loadItem(node2);
                continue;
            }
            if (node2.getNodeType() == 3) continue;
            this.attributes.put(string, RSS.getXMLText(node2));
        }
    }

    private void loadItem(Node node) {
        RSSItem rSSItem = new RSSItem();
        rSSItem.load(node);
        this.items.add(rSSItem);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Loaded RSS item:" + rSSItem);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Set<String> set = this.attributes.keySet();
        for (String object : set) {
            stringBuilder.append(object);
            stringBuilder.append('=');
            stringBuilder.append(this.attributes.get(object));
            stringBuilder.append('\n');
        }
        stringBuilder.append("Items:\n");
        for (RSSItem rSSItem : this.items) {
            stringBuilder.append(rSSItem.toString());
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

