/*
 * Decompiled with CFR 0.152.
 */
package org.encog.bot.browse.range;

import java.util.ArrayList;
import java.util.List;
import org.encog.bot.browse.WebPage;
import org.encog.bot.dataunit.DataUnit;
import org.encog.bot.dataunit.TextDataUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentRange {
    private int begin;
    private int end;
    private WebPage source;
    private String idAttribute;
    private String classAttribute;
    private final List<DocumentRange> elements = new ArrayList<DocumentRange>();
    private DocumentRange parent;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public DocumentRange(WebPage webPage) {
        this.source = webPage;
    }

    public void addElement(DocumentRange documentRange) {
        this.elements.add(documentRange);
        documentRange.setParent(this);
    }

    public int getBegin() {
        return this.begin;
    }

    public String getClassAttribute() {
        return this.classAttribute;
    }

    public List<DocumentRange> getElements() {
        return this.elements;
    }

    public int getEnd() {
        return this.end;
    }

    public String getIdAttribute() {
        return this.idAttribute;
    }

    public DocumentRange getParent() {
        return this.parent;
    }

    public WebPage getSource() {
        return this.source;
    }

    public String getTextOnly() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = this.getBegin(); i < this.getEnd(); ++i) {
            DataUnit dataUnit = this.source.getData().get(i);
            if (!(dataUnit instanceof TextDataUnit)) continue;
            stringBuilder.append(dataUnit.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public void setBegin(int n) {
        this.begin = n;
    }

    public void setClassAttribute(String string) {
        this.classAttribute = string;
    }

    public void setEnd(int n) {
        this.end = n;
    }

    public void setIdAttribute(String string) {
        this.idAttribute = string;
    }

    public void setParent(DocumentRange documentRange) {
        this.parent = documentRange;
    }

    public void setSource(WebPage webPage) {
        this.source = webPage;
    }

    public String toString() {
        return this.getTextOnly();
    }
}

