/*
 * Decompiled with CFR 0.152.
 */
package org.encog.bot.browse;

import java.util.ArrayList;
import java.util.List;
import org.encog.bot.browse.range.DocumentRange;
import org.encog.bot.browse.range.Link;
import org.encog.bot.dataunit.DataUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebPage {
    private final List<DataUnit> data = new ArrayList<DataUnit>();
    private final List<DocumentRange> contents = new ArrayList<DocumentRange>();
    private DocumentRange title;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void addContent(DocumentRange documentRange) {
        documentRange.setSource(this);
        this.contents.add(documentRange);
    }

    public void addDataUnit(DataUnit dataUnit) {
        this.data.add(dataUnit);
    }

    public DocumentRange find(Class<?> clazz, int n) {
        int n2 = n;
        for (DocumentRange documentRange : this.getContents()) {
            if (!documentRange.getClass().getName().equals(clazz.getName())) continue;
            if (n2 <= 0) {
                return documentRange;
            }
            --n2;
        }
        return null;
    }

    public Link findLink(String string) {
        for (DocumentRange documentRange : this.getContents()) {
            Link link;
            if (!(documentRange instanceof Link) || !(link = (Link)documentRange).getTextOnly().equals(string)) continue;
            return link;
        }
        return null;
    }

    public List<DocumentRange> getContents() {
        return this.contents;
    }

    public List<DataUnit> getData() {
        return this.data;
    }

    public int getDataSize() {
        return this.data.size();
    }

    public DataUnit getDataUnit(int n) {
        return this.data.get(n);
    }

    public DocumentRange getTitle() {
        return this.title;
    }

    public void setTitle(DocumentRange documentRange) {
        this.title = documentRange;
        this.title.setSource(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (DocumentRange documentRange : this.getContents()) {
            stringBuilder.append(documentRange.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

