/*
 * Decompiled with CFR 0.152.
 */
package org.encog.bot.browse;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.encog.bot.browse.Address;
import org.encog.bot.browse.BrowseError;
import org.encog.bot.browse.LoadWebPage;
import org.encog.bot.browse.WebPage;
import org.encog.bot.browse.range.DocumentRange;
import org.encog.bot.browse.range.Form;
import org.encog.bot.browse.range.FormElement;
import org.encog.bot.browse.range.Input;
import org.encog.bot.browse.range.Link;
import org.encog.util.http.FormUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Browser {
    private WebPage currentPage;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public WebPage getCurrentPage() {
        return this.currentPage;
    }

    public void navigate(Form form) {
        this.navigate(form, null);
    }

    public void navigate(Form form, Input input) {
        try {
            InputStream inputStream;
            URL uRL;
            OutputStream outputStream;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Posting a form");
            }
            URLConnection uRLConnection = null;
            if (form.getMethod() == Form.Method.GET) {
                outputStream = new ByteArrayOutputStream();
            } else {
                uRLConnection = form.getAction().getUrl().openConnection();
                outputStream = uRLConnection.getOutputStream();
            }
            FormUtility formUtility = new FormUtility(outputStream, null);
            for (DocumentRange documentRange : form.getElements()) {
                FormElement formElement;
                if (!(documentRange instanceof FormElement) || (formElement = (FormElement)documentRange) != input && !formElement.isAutoSend()) continue;
                String string = formElement.getName();
                String string2 = formElement.getValue();
                if (string == null) continue;
                if (string2 == null) {
                    string2 = "";
                }
                formUtility.add(string, string2);
            }
            if (form.getMethod() == Form.Method.GET) {
                Object object = form.getAction().getUrl().toString();
                outputStream.close();
                object = (String)object + "?";
                object = (String)object + outputStream.toString();
                uRL = new URL((String)object);
                uRLConnection = uRL.openConnection();
                inputStream = uRLConnection.getInputStream();
            } else {
                uRL = form.getAction().getUrl();
                outputStream.close();
                inputStream = uRLConnection.getInputStream();
            }
            this.navigate(uRL, inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new BrowseError(iOException);
        }
    }

    public void navigate(Link link) {
        Address address = link.getTarget();
        if (address.getUrl() != null) {
            this.navigate(address.getUrl());
        } else {
            this.navigate(address.getOriginal());
        }
    }

    public void navigate(String string) {
        try {
            this.navigate(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception", (Throwable)malformedURLException);
            }
            throw new BrowseError(malformedURLException);
        }
    }

    public void navigate(URL uRL) {
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Navigating to page:" + uRL);
            }
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            this.navigate(uRL, inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception", (Throwable)iOException);
            }
            throw new BrowseError(iOException);
        }
    }

    public void navigate(URL uRL, InputStream inputStream) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("POSTing to page:" + uRL);
        }
        LoadWebPage loadWebPage = new LoadWebPage(uRL);
        this.currentPage = loadWebPage.load(inputStream);
    }

    public void setCurrentPage(WebPage webPage) {
        this.currentPage = webPage;
    }
}

