/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.dsproc;

import jams.workspace.dsproc.DataMatrix;
import jams.workspace.dsproc.DataStoreProcessor;
import jams.workspace.dsproc.DataStoreProcessorOMS;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractDataStoreProcessor {
    protected AbstractDataStoreProcessor(File dsFile) {
    }

    public abstract boolean isEmpty();

    public abstract AbstractDataStoreProcessor[] getSubDataStores();

    public static AbstractDataStoreProcessor getProcessor(File dsFile) {
        if (dsFile.getName().endsWith(".csv")) {
            try {
                return new DataStoreProcessorOMS(dsFile);
            }
            catch (Exception ex) {
                Logger.getLogger(AbstractDataStoreProcessor.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }
        return new DataStoreProcessor(dsFile);
    }

    public static DataStoreType getDataStoreType(File file) {
        if (file.getName().endsWith(".csv")) {
            return DataStoreProcessorOMS.getDataStoreType(file);
        }
        return DataStoreProcessor.getDataStoreType(file);
    }

    public abstract void createDB() throws IOException, SQLException, ClassNotFoundException;

    public abstract void clearDB() throws SQLException;

    public abstract void removeDBFiles();

    public abstract void close() throws SQLException;

    public abstract boolean existsH2DB() throws SQLException;

    public abstract boolean isDBObsolete();

    public abstract boolean existsH2DBFiles();

    public abstract Connection getH2Connection(boolean var1) throws SQLException;

    public abstract void cancelCreateIndex();

    public abstract boolean fillBlock(long var1) throws IOException, SQLException;

    public abstract boolean isTimeSpaceDatastore();

    public abstract boolean isEnsembleTimeSeriesDatastore();

    public abstract boolean isSimpleTimeSerieDatastore();

    public abstract boolean isSimpleDataSerieDatastore();

    public abstract ArrayList<ContextData> getContexts();

    public abstract ArrayList<FilterData> getFilters();

    public abstract ArrayList<AttributeData> getAttributes();

    public abstract File getFile();

    public abstract void addImportProgressObserver(Observer var1);

    public abstract int getSize();

    public abstract long getStartPosition() throws IOException;

    public abstract DataMatrix getData(long var1) throws IOException;

    public abstract String[] getSelectedDoubleAttribs();

    protected class ImportProgressObservable
    extends Observable {
        protected ImportProgressObservable() {
        }

        protected void setProgress(int progress) {
            this.setChanged();
            this.notifyObservers(progress);
        }
    }

    public class AttributeData
    implements Comparable {
        public static final boolean SELECTION_DEFAULT = false;
        public static final int AGGREGATION_SUM = 1;
        public static final int AGGREGATION_MEAN = 2;
        public static final int WEIGHTING_NONE = 1;
        public static final int WEIGHTING_TIMES_AREA = 2;
        public static final int WEIGHTING_DIV_AREA = 3;
        private String type;
        private String name;
        private boolean selected;
        private int aggregationType = 2;
        private int weightingType = 1;

        public AttributeData(String type, String name) {
            this.type = type;
            this.name = name;
            this.selected = false;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public boolean isSelected() {
            return this.selected;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSelected(boolean selected) {
            AbstractDataStoreProcessor abstractDataStoreProcessor = AbstractDataStoreProcessor.this;
            synchronized (abstractDataStoreProcessor) {
                this.selected = selected;
            }
        }

        public int getAggregationType() {
            return this.aggregationType;
        }

        public int getWeightingType() {
            return this.weightingType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAggregationType(int aggregationType) {
            AbstractDataStoreProcessor abstractDataStoreProcessor = AbstractDataStoreProcessor.this;
            synchronized (abstractDataStoreProcessor) {
                this.aggregationType = aggregationType;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setWeightingType(int weightingType) {
            AbstractDataStoreProcessor abstractDataStoreProcessor = AbstractDataStoreProcessor.this;
            synchronized (abstractDataStoreProcessor) {
                this.weightingType = weightingType;
            }
        }

        public int compareTo(Object obj) {
            return this.getName().compareTo(((AttributeData)obj).getName());
        }
    }

    public class FilterData {
        private String regex;
        private String contextName;

        public FilterData(String regex, String contextName) {
            this.regex = regex;
            this.contextName = contextName;
        }

        public String getRegex() {
            return this.regex;
        }

        public String getContextName() {
            return this.contextName;
        }
    }

    public class ContextData {
        private String type;
        private String name;
        private String idType;
        private int size;

        public ContextData(String type, String name, String size, String idType) {
            this.type = type;
            this.name = name;
            this.size = Integer.parseInt(size);
            if (idType == null) {
                this.idType = type.equals("jams.model.JAMSTemporalContext") ? "JAMSCalendar" : (type.equals("jams.model.JAMSSpatialContext") ? "JAMSLong" : (type.contains("jams.components.optimizer") || type.contains("optas.optimizer") || type.contains("dump") ? "JAMSLong" : "JAMSLong"));
            }
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getIdType() {
            return this.idType;
        }

        public int getSize() {
            return this.size;
        }
    }

    public static enum DataStoreType {
        Unsupported,
        Timeserie,
        SpatioTemporal,
        DataSerie1D,
        TimeDataSerie;

    }
}

