/*
 * Decompiled with CFR 0.152.
 */
package jams;

import jams.JAMS;
import jams.JAMSProperty;
import jams.SystemProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Set;

public class JAMSProperties
extends Observable
implements SystemProperties,
Serializable {
    private Properties properties = new Properties();
    private String defaultFilename = "";
    private HashMap<String, JAMSProperty> propertyMap = new HashMap();
    private static JAMSProperties theProperties;

    public JAMSProperties(Properties properties) {
        if (properties != null) {
            this.properties = properties;
        }
    }

    public void load(String fileName) throws IOException {
        this.properties.load(new FileInputStream(fileName));
        this.defaultFilename = fileName;
        this.convertToBoolean();
        for (Object key : this.properties.keySet()) {
            JAMSProperty property = this.propertyMap.get(key);
            if (property == null) {
                property = new JAMSProperty((String)key);
                this.propertyMap.put((String)key, property);
            }
            property.setChanged();
            property.notifyObservers();
        }
    }

    private void convertToBoolean() {
        if ("1".equals(this.properties.getProperty("errordlg"))) {
            this.properties.setProperty("errordlg", "true");
        }
        if ("1".equals(this.properties.getProperty("windowenable"))) {
            this.properties.setProperty("windowenable", "true");
        }
        if ("1".equals(this.properties.getProperty("guiconfig"))) {
            this.properties.setProperty("guiconfig", "true");
        }
        if ("1".equals(this.properties.getProperty("defaultworkspace"))) {
            this.properties.setProperty("defaultworkspace", "true");
        }
    }

    public void save(String fileName) throws IOException {
        this.properties.store(new FileOutputStream(fileName), JAMS.i18n("JAMS_configuration_file"));
        this.defaultFilename = fileName;
    }

    public void save() throws IOException {
        this.save(this.defaultFilename);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        if (this.getProperty(key) != null) {
            return this.getProperty(key);
        }
        return defaultValue;
    }

    public Set<String> getKeys() {
        return this.propertyMap.keySet();
    }

    public void setProperty(String key, String value) {
        JAMSProperty property = this.propertyMap.get(key);
        if (property == null) {
            property = new JAMSProperty(key);
            this.propertyMap.put(key, property);
        }
        if (this.properties.getProperty(key) == null || !this.properties.getProperty(key).equals(value)) {
            this.properties.setProperty(key, value);
            property.setChanged();
            property.notifyObservers();
        }
    }

    public void addObserver(String key, Observer obs) {
        JAMSProperty property = this.propertyMap.get(key);
        if (property == null) {
            property = new JAMSProperty(key);
            this.propertyMap.put(key, property);
        }
        property.addObserver(obs);
    }

    public String toString() {
        return this.properties.toString();
    }

    public static JAMSProperties createProperties() {
        if (theProperties == null) {
            Properties p = new Properties();
            p.setProperty("model", "");
            p.setProperty("libs", ".;lib");
            p.setProperty("debug", "1");
            p.setProperty("verbose", "false");
            p.setProperty("infolog", "");
            p.setProperty("errorlog", "");
            p.setProperty("errordlg", "true");
            p.setProperty("windowenable", "true");
            p.setProperty("windowwidth", "900");
            p.setProperty("windowheight", "600");
            p.setProperty("guiconfig", "true");
            p.setProperty("guiconfigwidth", "600");
            p.setProperty("guiconfigheight", "600");
            p.setProperty("charset", "");
            p.setProperty("profiling", "false");
            p.setProperty("defaultworkspace", "true");
            p.setProperty("preprocessing", "true");
            p.setProperty("floatformat", "%f");
            p.setProperty("maxrecentfiles", "5");
            p.setProperty("maxlibclasses", "10000");
            theProperties = new JAMSProperties(p);
            JAMSProperties.theProperties.defaultFilename = System.getProperty("user.dir") + File.separator + "default.jap";
        }
        return theProperties;
    }
}

