/*
 * Decompiled with CFR 0.152.
 */
package jams;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;

public class JAMSLogging
extends Observable {
    private static final List<Logger> loggers = new ArrayList<Logger>();
    private static final JAMSLogging instance = new JAMSLogging();

    public static void registerLogger(Logger logger) {
        if (!loggers.contains(logger)) {
            loggers.add(logger);
            instance.setChanged();
            instance.notifyObservers(logger);
        }
    }

    public static boolean unregisterLogger(Logger logger) {
        boolean result = loggers.remove(logger);
        instance.setChanged();
        instance.notifyObservers(logger);
        return result;
    }

    public static List<Logger> getLoggers() {
        return loggers;
    }

    @Override
    public void addObserver(Observer o) {
        instance.deleteObserver(o);
        super.addObserver(o);
    }

    public static JAMSLogging getInstance() {
        return instance;
    }
}

