/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.wms;

import gov.nasa.worldwind.util.Logging;

public class BoundingBox {
    private String crs;
    private double minx;
    private double maxx;
    private double miny;
    private double maxy;
    private double resx;
    private double resy;

    public static BoundingBox createFromStrings(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        BoundingBox boundingBox = new BoundingBox();
        try {
            boundingBox.crs = string;
            boundingBox.minx = Double.parseDouble(string2);
            boundingBox.maxx = Double.parseDouble(string3);
            boundingBox.miny = Double.parseDouble(string4);
            boundingBox.maxy = Double.parseDouble(string5);
            boundingBox.resx = string6 != null && !string6.equals("") ? Double.parseDouble(string6) : 0.0;
            boundingBox.resy = string7 != null && !string7.equals("") ? Double.parseDouble(string7) : 0.0;
        }
        catch (NumberFormatException numberFormatException) {
            String string8 = Logging.getMessage("XML.ImproperDataType");
            Logging.logger().severe(string8);
            throw numberFormatException;
        }
        return boundingBox;
    }

    public String getCrs() {
        return this.crs;
    }

    public double getMinx() {
        return this.minx;
    }

    public double getMaxx() {
        return this.maxx;
    }

    public double getMiny() {
        return this.miny;
    }

    public double getMaxy() {
        return this.maxy;
    }

    public double getResx() {
        return this.resx;
    }

    public double getResy() {
        return this.resy;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.crs);
        stringBuilder.append(": minx = ");
        stringBuilder.append(this.minx);
        stringBuilder.append(" miny = ");
        stringBuilder.append(this.miny);
        stringBuilder.append(" maxx = ");
        stringBuilder.append(this.maxx);
        stringBuilder.append(" maxy = ");
        stringBuilder.append(this.maxy);
        stringBuilder.append(" resx = ");
        stringBuilder.append(this.resx);
        stringBuilder.append(" resy = ");
        stringBuilder.append(this.resy);
        return stringBuilder.toString();
    }
}

