/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view.orbit;

import gov.nasa.worldwind.animation.AngleAnimator;
import gov.nasa.worldwind.animation.AnimationSupport;
import gov.nasa.worldwind.animation.CompoundAnimator;
import gov.nasa.worldwind.animation.DoubleAnimator;
import gov.nasa.worldwind.animation.Interpolator;
import gov.nasa.worldwind.animation.PositionAnimator;
import gov.nasa.worldwind.animation.ScheduledInterpolator;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.PropertyAccessor;
import gov.nasa.worldwind.view.ViewElevationAnimator;
import gov.nasa.worldwind.view.ViewPropertyAccessor;
import gov.nasa.worldwind.view.orbit.BasicOrbitView;
import gov.nasa.worldwind.view.orbit.OrbitView;
import gov.nasa.worldwind.view.orbit.OrbitViewPropertyAccessor;

public class FlyToOrbitViewAnimator
extends CompoundAnimator {
    int altitudeMode;
    PositionAnimator centerAnimator;
    ViewElevationAnimator zoomAnimator;
    AngleAnimator headingAnimator;
    AngleAnimator pitchAnimator;
    AngleAnimator rollAnimator;
    BasicOrbitView orbitView;

    public FlyToOrbitViewAnimator(OrbitView orbitView, Interpolator interpolator, int n, PositionAnimator positionAnimator, DoubleAnimator doubleAnimator, AngleAnimator angleAnimator, AngleAnimator angleAnimator2, AngleAnimator angleAnimator3) {
        super(interpolator, positionAnimator, doubleAnimator, angleAnimator, angleAnimator2, angleAnimator3);
        this.orbitView = (BasicOrbitView)orbitView;
        this.centerAnimator = positionAnimator;
        this.zoomAnimator = (ViewElevationAnimator)doubleAnimator;
        this.headingAnimator = angleAnimator;
        this.pitchAnimator = angleAnimator2;
        this.rollAnimator = angleAnimator3;
        if (interpolator == null) {
            this.interpolator = new ScheduledInterpolator(10000L);
        }
        this.altitudeMode = n;
    }

    public static FlyToOrbitViewAnimator createFlyToOrbitViewAnimator(OrbitView orbitView, Position position, Position position2, Angle angle, Angle angle2, Angle angle3, Angle angle4, double d, double d2, long l, int n) {
        OnSurfacePositionAnimator onSurfacePositionAnimator = new OnSurfacePositionAnimator(orbitView.getGlobe(), new ScheduledInterpolator(l), position, position2, OrbitViewPropertyAccessor.createCenterPositionAccessor(orbitView), n);
        ViewElevationAnimator viewElevationAnimator = new ViewElevationAnimator(orbitView.getGlobe(), d, d2, position, position2, 0, OrbitViewPropertyAccessor.createZoomAccessor(orbitView));
        onSurfacePositionAnimator.useMidZoom = viewElevationAnimator.getUseMidZoom();
        AngleAnimator angleAnimator = new AngleAnimator(new ScheduledInterpolator(l), angle, angle2, ViewPropertyAccessor.createHeadingAccessor(orbitView));
        AngleAnimator angleAnimator2 = new AngleAnimator(new ScheduledInterpolator(l), angle3, angle4, ViewPropertyAccessor.createPitchAccessor(orbitView));
        FlyToOrbitViewAnimator flyToOrbitViewAnimator = new FlyToOrbitViewAnimator(orbitView, new ScheduledInterpolator(l), n, onSurfacePositionAnimator, viewElevationAnimator, angleAnimator, angleAnimator2, null);
        return flyToOrbitViewAnimator;
    }

    @Override
    public void stop() {
        if (this.altitudeMode == 1) {
            this.orbitView.setViewOutOfFocus(true);
        }
        super.stop();
    }

    protected static class OnSurfacePositionAnimator
    extends PositionAnimator {
        Globe globe;
        int altitudeMode;
        boolean useMidZoom = true;

        public OnSurfacePositionAnimator(Globe globe, Interpolator interpolator, Position position, Position position2, PropertyAccessor.PositionAccessor positionAccessor, int n) {
            super(interpolator, position, position2, positionAccessor);
            this.globe = globe;
            this.altitudeMode = n;
        }

        @Override
        protected Position nextPosition(double d) {
            double d2 = this.useMidZoom ? 0.2 : 0.0;
            double d3 = this.useMidZoom ? 0.8 : 0.8;
            double d4 = AnimationSupport.basicInterpolant(d, d2, d3, 1);
            Position position = super.nextPosition(d4);
            double d5 = 0.0;
            boolean bl = false;
            if (this.altitudeMode == 1) {
                bl = true;
                d5 = this.globe.getElevation(this.getEnd().getLatitude(), this.getEnd().getLongitude());
            } else if (this.altitudeMode == 2) {
                bl = true;
                d5 = this.globe.getElevation(this.getEnd().getLatitude(), this.getEnd().getLongitude()) + this.getEnd().getAltitude();
            }
            if (bl) {
                Position position2 = position;
                double d6 = this.getBegin().getElevation();
                position = new Position(position2, (1.0 - d4) * d6 + d4 * d5);
            }
            return position;
        }
    }
}

