/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view.orbit;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.awt.ViewInputHandler;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.view.BasicView;
import gov.nasa.worldwind.view.orbit.BasicOrbitViewLimits;
import gov.nasa.worldwind.view.orbit.OrbitView;
import gov.nasa.worldwind.view.orbit.OrbitViewCollisionSupport;
import gov.nasa.worldwind.view.orbit.OrbitViewInputHandler;
import gov.nasa.worldwind.view.orbit.OrbitViewInputSupport;
import gov.nasa.worldwind.view.orbit.OrbitViewLimits;
import java.awt.Rectangle;
import java.util.logging.Level;

public class BasicOrbitView
extends BasicView
implements OrbitView {
    protected Position center = Position.ZERO;
    protected double zoom;
    protected boolean viewOutOfFocus;
    protected final OrbitViewCollisionSupport collisionSupport = new OrbitViewCollisionSupport();

    public BasicOrbitView() {
        this.viewInputHandler = (ViewInputHandler)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.ViewInputHandlerClassName");
        this.viewLimits = new BasicOrbitViewLimits();
        if (this.viewInputHandler == null) {
            this.viewInputHandler = new OrbitViewInputHandler();
        }
        this.collisionSupport.setCollisionThreshold(10.0);
        this.collisionSupport.setNumIterations(4);
        this.loadConfigurationValues();
    }

    protected void loadConfigurationValues() {
        Double d;
        Double d2;
        Double d3;
        Double d4 = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.InitialLatitude");
        Double d5 = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.InitialLongitude");
        double d6 = this.center.getElevation();
        if (d4 != null && d5 != null) {
            this.setCenterPosition(Position.fromDegrees(d4, d5, d6));
        } else if (d4 != null) {
            this.setCenterPosition(Position.fromDegrees(d4, this.center.getLongitude().degrees, d6));
        } else if (d5 != null) {
            this.setCenterPosition(Position.fromDegrees(this.center.getLatitude().degrees, d5, d6));
        }
        Double d7 = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.InitialHeading");
        if (d7 != null) {
            this.setHeading(Angle.fromDegrees(d7));
        }
        if ((d3 = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.InitialPitch")) != null) {
            this.setPitch(Angle.fromDegrees(d3));
        }
        if ((d2 = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.InitialAltitude")) != null) {
            this.setZoom(d2);
        }
        if ((d = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.FieldOfView")) != null) {
            this.setFieldOfView(Angle.fromDegrees(d));
        }
        this.setViewOutOfFocus(true);
    }

    protected void flagHadCollisions() {
        this.hadCollisions = true;
    }

    @Override
    public void stopMovementOnCenter() {
        this.firePropertyChange("gov.nasa.worldwind.view.orbit.OrbitView.CenterStopped", null, null);
    }

    @Override
    public void copyViewState(View view) {
        this.globe = view.getGlobe();
        Vec4 vec4 = view.getCenterPoint();
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setOrientation(view.getEyePosition(), this.globe.computePositionFromPoint(vec4));
    }

    @Override
    public Position getCenterPosition() {
        return this.center;
    }

    @Override
    public Vec4 getCenterPoint() {
        return this.globe.computePointFromPosition(this.center);
    }

    @Override
    public void setCenterPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position.getLatitude().degrees < -90.0 || position.getLatitude().degrees > 90.0) {
            String string = Logging.getMessage("generic.LatitudeOutOfRange", position.getLatitude());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.center = BasicOrbitView.normalizedCenterPosition(position);
        this.center = BasicOrbitViewLimits.limitCenterPosition(this.center, this.getOrbitViewLimits());
        this.resolveCollisionsWithCenterPosition();
        this.updateModelViewStateID();
    }

    @Override
    public void setHeading(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.heading = BasicOrbitView.normalizedHeading(angle);
        this.heading = BasicOrbitViewLimits.limitHeading(this.heading, this.getOrbitViewLimits());
        this.resolveCollisionsWithPitch();
        this.updateModelViewStateID();
    }

    @Override
    public void setPitch(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pitch = BasicOrbitView.normalizedPitch(angle);
        this.pitch = BasicOrbitViewLimits.limitPitch(this.pitch, this.getOrbitViewLimits());
        this.resolveCollisionsWithPitch();
        this.updateModelViewStateID();
    }

    @Override
    public double getZoom() {
        return this.zoom;
    }

    @Override
    public void setZoom(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.zoom = d;
        this.zoom = BasicOrbitViewLimits.limitZoom(this.zoom, this.getOrbitViewLimits());
        this.resolveCollisionsWithCenterPosition();
        this.updateModelViewStateID();
    }

    @Override
    public OrbitViewLimits getOrbitViewLimits() {
        return (OrbitViewLimits)this.viewLimits;
    }

    @Override
    public void setOrbitViewLimits(OrbitViewLimits orbitViewLimits) {
        if (orbitViewLimits == null) {
            String string = Logging.getMessage("nullValue.ViewLimitsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.viewLimits = orbitViewLimits;
    }

    public static Position normalizedCenterPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Position(Angle.normalizedLatitude(position.getLatitude()), Angle.normalizedLongitude(position.getLongitude()), position.getElevation());
    }

    public static Angle normalizedHeading(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.degrees;
        double d2 = d % 360.0;
        return Angle.fromDegrees(d2 > 180.0 ? d2 - 360.0 : (d2 < -180.0 ? 360.0 + d2 : d2));
    }

    public static Angle normalizedPitch(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.degrees;
        double d2 = d % 360.0;
        return Angle.fromDegrees(d2 > 180.0 ? d2 - 360.0 : (d2 < -180.0 ? 360.0 + d2 : d2));
    }

    protected void resolveCollisionsWithCenterPosition() {
        if (this.dc == null) {
            return;
        }
        if (!this.isDetectCollisions()) {
            return;
        }
        double d = this.computeNearDistance(this.getCurrentEyePosition());
        Position position = this.collisionSupport.computeCenterPositionToResolveCollision(this, d, this.dc);
        if (position != null && position.getLatitude().degrees >= -90.0 && position.getLongitude().degrees <= 90.0) {
            this.center = position;
            this.flagHadCollisions();
        }
    }

    protected void resolveCollisionsWithPitch() {
        if (this.dc == null) {
            return;
        }
        if (!this.isDetectCollisions()) {
            return;
        }
        double d = this.computeNearDistance(this.getCurrentEyePosition());
        Angle angle = this.collisionSupport.computePitchToResolveCollision(this, d, this.dc);
        if (angle != null && angle.degrees <= 90.0 && angle.degrees >= 0.0) {
            this.pitch = angle;
            this.flagHadCollisions();
        }
    }

    public void computeAndSetViewCenterIfNeeded() {
        if (this.viewOutOfFocus) {
            this.computeAndSetViewCenter();
        }
    }

    public void computeAndSetViewCenter() {
        try {
            if (this.canFocusOnViewportCenter()) {
                this.focusOnViewportCenter();
                this.setViewOutOfFocus(false);
            }
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionWhileChangingView");
            Logging.logger().log(Level.SEVERE, string, exception);
            this.setViewOutOfFocus(true);
        }
    }

    public void setViewOutOfFocus(boolean bl) {
        this.viewOutOfFocus = bl;
    }

    @Override
    public boolean canFocusOnViewportCenter() {
        return this.dc != null && this.dc.getViewportCenterPosition() != null && this.globe != null;
    }

    @Override
    public void focusOnViewportCenter() {
        Matrix matrix;
        Matrix matrix2;
        if (this.isAnimating()) {
            return;
        }
        if (this.dc == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (this.globe == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Position position = this.dc.getViewportCenterPosition();
        if (position == null) {
            String string = Logging.getMessage("nullValue.DrawingContextViewportCenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Vec4 vec4 = this.globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), this.globe.getElevation(position.getLatitude(), position.getLongitude()) * this.dc.getVerticalExaggeration());
        if (vec4 != null && (matrix2 = OrbitViewInputSupport.computeTransformMatrix(this.globe, this.center, this.heading, this.pitch, this.roll, this.zoom)) != null && (matrix = matrix2.getInverse()) != null) {
            Vec4 vec42 = Vec4.UNIT_W.transformBy4(matrix);
            Vec4 vec43 = Vec4.UNIT_NEGATIVE_Z.transformBy4(matrix);
            double d = vec42.distanceTo3(vec4);
            Vec4 vec44 = Vec4.fromLine3(vec42, d, vec43);
            OrbitViewInputSupport.OrbitViewState orbitViewState = OrbitViewInputSupport.computeOrbitViewState(this.globe, matrix2, vec44);
            if (this.validateModelCoordinates(orbitViewState)) {
                this.setModelCoordinates(orbitViewState);
            }
        }
    }

    public boolean canFocusOnTerrainCenter() {
        return this.dc != null && this.dc.getSurfaceGeometry() != null && this.globe != null;
    }

    public void focusOnTerrainCenter() {
        Matrix matrix;
        if (this.dc == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (this.globe == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (this.dc.getSurfaceGeometry() == null) {
            return;
        }
        if (this.isAnimating()) {
            return;
        }
        Matrix matrix2 = OrbitViewInputSupport.computeTransformMatrix(this.globe, this.center, this.heading, this.pitch, this.roll, this.zoom);
        if (matrix2 != null && (matrix = matrix2.getInverse()) != null) {
            Vec4 vec4;
            OrbitViewInputSupport.OrbitViewState orbitViewState;
            Vec4 vec42 = Vec4.UNIT_W.transformBy4(matrix);
            Vec4 vec43 = Vec4.UNIT_NEGATIVE_Z.transformBy4(matrix);
            Intersection[] intersectionArray = this.dc.getSurfaceGeometry().intersect(new Line(vec42, vec43));
            if (intersectionArray != null && intersectionArray.length > 0 && this.validateModelCoordinates(orbitViewState = OrbitViewInputSupport.computeOrbitViewState(this.globe, matrix2, vec4 = intersectionArray[0].getIntersectionPoint()))) {
                this.setModelCoordinates(orbitViewState);
            }
        }
    }

    @Override
    public void setEyePosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = position.getElevation();
        this.center = new Position(position, d >= 0.0 ? 0.0 : d);
        this.heading = Angle.ZERO;
        this.pitch = Angle.ZERO;
        this.zoom = d >= 0.0 ? d : 0.0;
        this.resolveCollisionsWithCenterPosition();
        this.updateModelViewStateID();
    }

    @Override
    public Vec4 getCurrentEyePoint() {
        Matrix matrix;
        Matrix matrix2;
        if (this.globe != null && (matrix2 = OrbitViewInputSupport.computeTransformMatrix(this.globe, this.center, this.heading, this.pitch, this.roll, this.zoom)) != null && (matrix = matrix2.getInverse()) != null) {
            return Vec4.UNIT_W.transformBy4(matrix);
        }
        return Vec4.ZERO;
    }

    @Override
    public Position getCurrentEyePosition() {
        Matrix matrix;
        Matrix matrix2;
        if (this.globe != null && (matrix2 = OrbitViewInputSupport.computeTransformMatrix(this.globe, this.center, this.heading, this.pitch, this.roll, this.zoom)) != null && (matrix = matrix2.getInverse()) != null) {
            Vec4 vec4 = Vec4.UNIT_W.transformBy4(matrix);
            return this.globe.computePositionFromPoint(vec4);
        }
        return Position.ZERO;
    }

    @Override
    public void setOrientation(Position position, Position position2) {
        Object object;
        Object object2;
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.globe == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Vec4 vec4 = this.globe.computePointFromPosition(position);
        Vec4 vec42 = this.globe.computePointFromPosition(position2);
        if (vec4 == null || vec42 == null) {
            String string = Logging.getMessage("View.ErrorSettingOrientation", position, position2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec43 = this.globe.computeSurfaceNormalAtPoint(vec42);
        Vec4 vec44 = vec42.subtract3(vec4).normalize3();
        if (vec44.cross3(vec43).getLength3() < 0.001 && (object2 = OrbitViewInputSupport.computeTransformMatrix(this.globe, position2, this.heading, Angle.ZERO, Angle.ZERO, 1.0)) != null && (object = ((Matrix)object2).getInverse()) != null) {
            vec43 = Vec4.UNIT_Y.transformBy4((Matrix)object);
        }
        if (vec43 == null) {
            object2 = Logging.getMessage("View.ErrorSettingOrientation", position, position2);
            Logging.logger().severe((String)object2);
            throw new IllegalArgumentException((String)object2);
        }
        object2 = OrbitViewInputSupport.computeOrbitViewState(this.globe, vec4, vec42, vec43);
        if (!this.validateModelCoordinates((OrbitViewInputSupport.OrbitViewState)object2)) {
            object = Logging.getMessage("View.ErrorSettingOrientation", position, position2);
            Logging.logger().severe((String)object);
            throw new IllegalArgumentException((String)object);
        }
        this.setModelCoordinates((OrbitViewInputSupport.OrbitViewState)object2);
    }

    @Override
    protected void doApply(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.dc = drawContext;
        this.globe = this.dc.getGlobe();
        this.modelview = OrbitViewInputSupport.computeTransformMatrix(this.globe, this.center, this.heading, this.pitch, this.roll, this.zoom);
        if (this.modelview == null) {
            this.modelview = Matrix.IDENTITY;
        }
        this.modelviewInv = this.modelview.getInverse();
        if (this.modelviewInv == null) {
            this.modelviewInv = Matrix.IDENTITY;
        }
        int[] nArray = new int[4];
        this.dc.getGL().glGetIntegerv(2978, nArray, 0);
        this.viewport = new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
        this.farClipDistance = this.computeFarClipDistance();
        this.nearClipDistance = this.computeNearClipDistance();
        double d = this.viewport.getWidth() <= 0.0 ? 1.0 : this.viewport.getWidth();
        double d2 = this.viewport.getHeight() <= 0.0 ? 1.0 : this.viewport.getHeight();
        this.projection = Matrix.fromPerspective(this.fieldOfView, d, d2, this.nearClipDistance, this.farClipDistance);
        this.frustum = Frustum.fromPerspective(this.fieldOfView, (int)d, (int)d2, this.nearClipDistance, this.farClipDistance);
        BasicOrbitView.loadGLViewState(drawContext, this.modelview, this.projection);
        this.afterDoApply();
    }

    protected void afterDoApply() {
        this.lastEyePosition = this.computeEyePositionFromModelview();
        this.horizonDistance = this.computeHorizonDistance();
        this.lastEyePoint = null;
        this.lastUpVector = null;
        this.lastForwardVector = null;
        this.lastFrustumInModelCoords = null;
    }

    protected void setModelCoordinates(OrbitViewInputSupport.OrbitViewState orbitViewState) {
        if (orbitViewState != null) {
            if (orbitViewState.getCenterPosition() != null) {
                this.center = BasicOrbitView.normalizedCenterPosition(orbitViewState.getCenterPosition());
                this.center = BasicOrbitViewLimits.limitCenterPosition(this.center, this.getOrbitViewLimits());
            }
            if (orbitViewState.getHeading() != null) {
                this.heading = BasicOrbitView.normalizedHeading(orbitViewState.getHeading());
                this.heading = BasicOrbitViewLimits.limitHeading(this.heading, this.getOrbitViewLimits());
            }
            if (orbitViewState.getPitch() != null) {
                this.pitch = BasicOrbitView.normalizedPitch(orbitViewState.getPitch());
                this.pitch = BasicOrbitViewLimits.limitPitch(this.pitch, this.getOrbitViewLimits());
            }
            this.zoom = orbitViewState.getZoom();
            this.zoom = BasicOrbitViewLimits.limitZoom(this.zoom, this.getOrbitViewLimits());
            this.updateModelViewStateID();
        }
    }

    protected boolean validateModelCoordinates(OrbitViewInputSupport.OrbitViewState orbitViewState) {
        return orbitViewState != null && orbitViewState.getCenterPosition() != null && orbitViewState.getCenterPosition().getLatitude().degrees >= -90.0 && orbitViewState.getCenterPosition().getLatitude().degrees <= 90.0 && orbitViewState.getHeading() != null && orbitViewState.getPitch() != null && orbitViewState.getPitch().degrees >= 0.0 && orbitViewState.getPitch().degrees <= 90.0 && orbitViewState.getZoom() >= 0.0;
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        RestorableSupport.StateObject stateObject2;
        super.doGetRestorableState(restorableSupport, stateObject);
        if (this.getCenterPosition() != null && (stateObject2 = restorableSupport.addStateObject(stateObject, "center")) != null) {
            restorableSupport.addStateValueAsDouble(stateObject2, "latitude", this.getCenterPosition().getLatitude().degrees);
            restorableSupport.addStateValueAsDouble(stateObject2, "longitude", this.getCenterPosition().getLongitude().degrees);
            restorableSupport.addStateValueAsDouble(stateObject2, "elevation", this.getCenterPosition().getElevation());
        }
        restorableSupport.addStateValueAsDouble(stateObject, "zoom", this.getZoom());
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        this.legacyRestoreState(restorableSupport, stateObject);
        super.doRestoreState(restorableSupport, stateObject);
        RestorableSupport.StateObject stateObject2 = restorableSupport.getStateObject(stateObject, "center");
        if (stateObject2 != null) {
            d = restorableSupport.getStateValueAsDouble(stateObject2, "latitude");
            Double d2 = restorableSupport.getStateValueAsDouble(stateObject2, "longitude");
            Double d3 = restorableSupport.getStateValueAsDouble(stateObject2, "elevation");
            if (d != null && d2 != null) {
                this.setCenterPosition(Position.fromDegrees(d, d2, d3 != null ? d3 : 0.0));
            }
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "zoom")) != null) {
            this.setZoom(d);
        }
    }

    protected void legacyRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        RestorableSupport.StateObject stateObject2 = restorableSupport.getStateObject(stateObject, "orbitViewLimits");
        if (stateObject2 != null) {
            this.getOrbitViewLimits().restoreState(restorableSupport, stateObject2);
        }
    }

    public void addPanToAnimator(Position position, Position position2, Angle angle, Angle angle2, Angle angle3, Angle angle4, double d, double d2, long l, boolean bl) {
        ((OrbitViewInputHandler)this.viewInputHandler).addPanToAnimator(position, position2, angle, angle2, angle3, angle4, d, d2, l, bl);
    }

    public void addPanToAnimator(Position position, Position position2, Angle angle, Angle angle2, Angle angle3, Angle angle4, double d, double d2, boolean bl) {
        ((OrbitViewInputHandler)this.viewInputHandler).addPanToAnimator(position, position2, angle, angle2, angle3, angle4, d, d2, bl);
    }

    public void addPanToAnimator(Position position, Angle angle, Angle angle2, double d, long l, boolean bl) {
        ((OrbitViewInputHandler)this.viewInputHandler).addPanToAnimator(position, angle, angle2, d, l, bl);
    }

    public void addPanToAnimator(Position position, Angle angle, Angle angle2, double d, boolean bl) {
        ((OrbitViewInputHandler)this.viewInputHandler).addPanToAnimator(position, angle, angle2, d, bl);
    }

    public void addPanToAnimator(Position position, Angle angle, Angle angle2, double d) {
        ((OrbitViewInputHandler)this.viewInputHandler).addPanToAnimator(position, angle, angle2, d);
    }

    public void addEyePositionAnimator(long l, Position position, Position position2) {
        ((OrbitViewInputHandler)this.viewInputHandler).addEyePositionAnimator(l, position, position2);
    }

    public void addHeadingAnimator(Angle angle, Angle angle2) {
        ((OrbitViewInputHandler)this.viewInputHandler).addHeadingAnimator(angle, angle2);
    }

    public void addPitchAnimator(Angle angle, Angle angle2) {
        ((OrbitViewInputHandler)this.viewInputHandler).addPitchAnimator(angle, angle2);
    }

    public void addHeadingPitchAnimator(Angle angle, Angle angle2, Angle angle3, Angle angle4) {
        ((OrbitViewInputHandler)this.viewInputHandler).addHeadingPitchRollAnimator(angle, angle2, angle3, angle4, this.getRoll(), this.getRoll());
    }

    public void addZoomAnimator(double d, double d2) {
        ((OrbitViewInputHandler)this.viewInputHandler).addZoomAnimator(d, d2);
    }

    public void addFlyToZoomAnimator(Angle angle, Angle angle2, double d) {
        ((OrbitViewInputHandler)this.viewInputHandler).addFlyToZoomAnimator(angle, angle2, d);
    }

    public void addCenterAnimator(Position position, Position position2, boolean bl) {
        ((OrbitViewInputHandler)this.viewInputHandler).addCenterAnimator(position, position2, bl);
    }

    public void addCenterAnimator(Position position, Position position2, long l, boolean bl) {
        ((OrbitViewInputHandler)this.viewInputHandler).addCenterAnimator(position, position2, l, bl);
    }
}

