/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view.firstperson;

import gov.nasa.worldwind.animation.AngleAnimator;
import gov.nasa.worldwind.animation.AnimationSupport;
import gov.nasa.worldwind.animation.CompoundAnimator;
import gov.nasa.worldwind.animation.DoubleAnimator;
import gov.nasa.worldwind.animation.Interpolator;
import gov.nasa.worldwind.animation.PositionAnimator;
import gov.nasa.worldwind.animation.ScheduledInterpolator;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.PropertyAccessor;
import gov.nasa.worldwind.view.ViewElevationAnimator;
import gov.nasa.worldwind.view.ViewPropertyAccessor;
import gov.nasa.worldwind.view.firstperson.BasicFlyView;

public class FlyToFlyViewAnimator
extends CompoundAnimator {
    int altitudeMode;

    public FlyToFlyViewAnimator(Interpolator interpolator, int n, PositionAnimator positionAnimator, DoubleAnimator doubleAnimator, AngleAnimator angleAnimator, AngleAnimator angleAnimator2, AngleAnimator angleAnimator3) {
        super(interpolator, positionAnimator, doubleAnimator, angleAnimator, angleAnimator2, angleAnimator3);
        if (interpolator == null) {
            this.interpolator = new ScheduledInterpolator(10000L);
        }
        this.altitudeMode = n;
    }

    public static FlyToFlyViewAnimator createFlyToFlyViewAnimator(BasicFlyView basicFlyView, Position position, Position position2, Angle angle, Angle angle2, Angle angle3, Angle angle4, double d, double d2, long l, int n) {
        return FlyToFlyViewAnimator.createFlyToFlyViewAnimator(basicFlyView, position, position2, angle, angle2, angle3, angle4, basicFlyView.getRoll(), basicFlyView.getRoll(), d, d2, l, n);
    }

    public static FlyToFlyViewAnimator createFlyToFlyViewAnimator(BasicFlyView basicFlyView, Position position, Position position2, Angle angle, Angle angle2, Angle angle3, Angle angle4, Angle angle5, Angle angle6, double d, double d2, long l, int n) {
        OnSurfacePositionAnimator onSurfacePositionAnimator = new OnSurfacePositionAnimator(basicFlyView.getGlobe(), new ScheduledInterpolator(l), position, position2, ViewPropertyAccessor.createEyePositionAccessor(basicFlyView), n);
        FlyToElevationAnimator flyToElevationAnimator = new FlyToElevationAnimator(basicFlyView, basicFlyView.getGlobe(), d, d2, position, position2, n, ViewPropertyAccessor.createElevationAccessor(basicFlyView));
        AngleAnimator angleAnimator = new AngleAnimator(new ScheduledInterpolator(l), angle, angle2, ViewPropertyAccessor.createHeadingAccessor(basicFlyView));
        AngleAnimator angleAnimator2 = new AngleAnimator(new ScheduledInterpolator(l), angle3, angle4, ViewPropertyAccessor.createPitchAccessor(basicFlyView));
        AngleAnimator angleAnimator3 = new AngleAnimator(new ScheduledInterpolator(l), angle5, angle6, ViewPropertyAccessor.createRollAccessor(basicFlyView));
        FlyToFlyViewAnimator flyToFlyViewAnimator = new FlyToFlyViewAnimator((Interpolator)new ScheduledInterpolator(l), n, onSurfacePositionAnimator, flyToElevationAnimator, angleAnimator, angleAnimator2, angleAnimator3);
        return flyToFlyViewAnimator;
    }

    public static class OnSurfacePositionAnimator
    extends PositionAnimator {
        Globe globe;
        int altitudeMode;
        boolean useMidZoom = true;

        public OnSurfacePositionAnimator(Globe globe, Interpolator interpolator, Position position, Position position2, PropertyAccessor.PositionAccessor positionAccessor, int n) {
            super(interpolator, position, position2, positionAccessor);
            this.globe = globe;
            this.altitudeMode = n;
        }

        @Override
        protected Position nextPosition(double d) {
            double d2 = this.useMidZoom ? 0.2 : 0.0;
            double d3 = this.useMidZoom ? 0.8 : 0.8;
            double d4 = AnimationSupport.basicInterpolant(d, d2, d3, 1);
            Position position = super.nextPosition(d4);
            double d5 = 0.0;
            boolean bl = false;
            if (this.altitudeMode == 1) {
                bl = true;
                d5 = this.globe.getElevation(this.getEnd().getLatitude(), this.getEnd().getLongitude());
            } else if (this.altitudeMode == 2) {
                bl = true;
                d5 = this.globe.getElevation(this.getEnd().getLatitude(), this.getEnd().getLongitude()) + this.getEnd().getAltitude();
            }
            if (bl) {
                Position position2 = position;
                double d6 = this.getBegin().getElevation();
                position = new Position(position2, (1.0 - d4) * d6 + d4 * d5);
            }
            return position;
        }
    }

    public static class FlyToElevationAnimator
    extends ViewElevationAnimator {
        public FlyToElevationAnimator(BasicFlyView basicFlyView, Globe globe, double d, double d2, LatLon latLon, LatLon latLon2, int n, PropertyAccessor.DoubleAccessor doubleAccessor) {
            super(globe, d, d2, latLon, latLon2, n, doubleAccessor);
            if (globe == null) {
                this.useMidZoom = false;
            } else {
                this.midZoom = FlyToElevationAnimator.computeMidZoom(globe, latLon, latLon2, d, d2);
                double d3 = basicFlyView.getViewPropertyLimits().getEyeElevationLimits()[1];
                if (this.midZoom > d3) {
                    this.midZoom = d3;
                }
                this.useMidZoom = this.useMidZoom(d, d2, this.midZoom);
            }
            if (this.useMidZoom) {
                this.trueEndZoom = d2;
                this.end = this.midZoom;
            }
        }
    }
}

